/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFUint64;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFUint64Ver15
implements OFUint64 {
    private static final Logger logger = LoggerFactory.getLogger(OFUint64Ver15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFUint64Ver15 DEFAULT = new OFUint64Ver15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFUint64Ver15Funnel FUNNEL = new OFUint64Ver15Funnel();
    static final Writer WRITER = new Writer();

    OFUint64Ver15(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFUint64Ver15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFUint64.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFUint64Ver15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFUint64Ver15 other = (OFUint64Ver15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFUint64Ver15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFUint64Ver15 message) {
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFUint64Ver15Funnel
    implements Funnel<OFUint64Ver15> {
        private static final long serialVersionUID = 1L;

        OFUint64Ver15Funnel() {
        }

        public void funnel(OFUint64Ver15 message, PrimitiveSink sink) {
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFUint64> {
        Reader() {
        }

        @Override
        public OFUint64 readFrom(ByteBuf bb) throws OFParseError {
            U64 value = U64.ofRaw(bb.readLong());
            OFUint64Ver15 uint64Ver15 = new OFUint64Ver15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)uint64Ver15);
            }
            return uint64Ver15;
        }
    }

    static class Builder
    implements OFUint64.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFUint64.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFUint64 build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFUint64Ver15(value);
        }
    }

    static class BuilderWithParent
    implements OFUint64.Builder {
        final OFUint64Ver15 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFUint64Ver15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFUint64.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFUint64 build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFUint64Ver15(value);
        }
    }
}

