/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTime;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTimeVer15
implements OFTime {
    private static final Logger logger = LoggerFactory.getLogger(OFTimeVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 16;
    private static final U64 DEFAULT_SECONDS = U64.ZERO;
    private static final long DEFAULT_NANOSECONDS = 0L;
    private final U64 seconds;
    private final long nanoseconds;
    static final OFTimeVer15 DEFAULT = new OFTimeVer15(DEFAULT_SECONDS, 0L);
    static final Reader READER = new Reader();
    static final OFTimeVer15Funnel FUNNEL = new OFTimeVer15Funnel();
    static final Writer WRITER = new Writer();

    OFTimeVer15(U64 seconds, long nanoseconds) {
        if (seconds == null) {
            throw new NullPointerException("OFTimeVer15: property seconds cannot be null");
        }
        this.seconds = seconds;
        this.nanoseconds = U32.normalize(nanoseconds);
    }

    @Override
    public U64 getSeconds() {
        return this.seconds;
    }

    @Override
    public long getNanoseconds() {
        return this.nanoseconds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFTime.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTimeVer15(");
        b.append("seconds=").append(this.seconds);
        b.append(", ");
        b.append("nanoseconds=").append(this.nanoseconds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTimeVer15 other = (OFTimeVer15)obj;
        if (this.seconds == null ? other.seconds != null : !this.seconds.equals(other.seconds)) {
            return false;
        }
        return this.nanoseconds == other.nanoseconds;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.seconds == null ? 0 : this.seconds.hashCode());
        result = 31 * (int)(this.nanoseconds ^ this.nanoseconds >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTimeVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTimeVer15 message) {
            bb.writeLong(message.seconds.getValue());
            bb.writeInt(U32.t(message.nanoseconds));
            bb.writeZero(4);
        }
    }

    static class OFTimeVer15Funnel
    implements Funnel<OFTimeVer15> {
        private static final long serialVersionUID = 1L;

        OFTimeVer15Funnel() {
        }

        public void funnel(OFTimeVer15 message, PrimitiveSink sink) {
            message.seconds.putTo(sink);
            sink.putLong(message.nanoseconds);
        }
    }

    static class Reader
    implements OFMessageReader<OFTime> {
        Reader() {
        }

        @Override
        public OFTime readFrom(ByteBuf bb) throws OFParseError {
            U64 seconds = U64.ofRaw(bb.readLong());
            long nanoseconds = U32.f(bb.readInt());
            bb.skipBytes(4);
            OFTimeVer15 timeVer15 = new OFTimeVer15(seconds, nanoseconds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)timeVer15);
            }
            return timeVer15;
        }
    }

    static class Builder
    implements OFTime.Builder {
        private boolean secondsSet;
        private U64 seconds;
        private boolean nanosecondsSet;
        private long nanoseconds;

        Builder() {
        }

        @Override
        public U64 getSeconds() {
            return this.seconds;
        }

        @Override
        public OFTime.Builder setSeconds(U64 seconds) {
            this.seconds = seconds;
            this.secondsSet = true;
            return this;
        }

        @Override
        public long getNanoseconds() {
            return this.nanoseconds;
        }

        @Override
        public OFTime.Builder setNanoseconds(long nanoseconds) {
            this.nanoseconds = nanoseconds;
            this.nanosecondsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTime build() {
            U64 seconds;
            U64 u64 = seconds = this.secondsSet ? this.seconds : DEFAULT_SECONDS;
            if (seconds == null) {
                throw new NullPointerException("Property seconds must not be null");
            }
            long nanoseconds = this.nanosecondsSet ? this.nanoseconds : 0L;
            return new OFTimeVer15(seconds, nanoseconds);
        }
    }

    static class BuilderWithParent
    implements OFTime.Builder {
        final OFTimeVer15 parentMessage;
        private boolean secondsSet;
        private U64 seconds;
        private boolean nanosecondsSet;
        private long nanoseconds;

        BuilderWithParent(OFTimeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U64 getSeconds() {
            return this.seconds;
        }

        @Override
        public OFTime.Builder setSeconds(U64 seconds) {
            this.seconds = seconds;
            this.secondsSet = true;
            return this;
        }

        @Override
        public long getNanoseconds() {
            return this.nanoseconds;
        }

        @Override
        public OFTime.Builder setNanoseconds(long nanoseconds) {
            this.nanoseconds = nanoseconds;
            this.nanosecondsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTime build() {
            U64 seconds;
            U64 u64 = seconds = this.secondsSet ? this.seconds : this.parentMessage.seconds;
            if (seconds == null) {
                throw new NullPointerException("Property seconds must not be null");
            }
            long nanoseconds = this.nanosecondsSet ? this.nanoseconds : this.parentMessage.nanoseconds;
            return new OFTimeVer15(seconds, nanoseconds);
        }
    }
}

