/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableFeaturePropWriteActionsMiss;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionId;
import org.projectfloodlight.openflow.protocol.ver15.OFActionIdVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableFeaturePropWriteActionsMissVer15
implements OFTableFeaturePropWriteActionsMiss {
    private static final Logger logger = LoggerFactory.getLogger(OFTableFeaturePropWriteActionsMissVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final List<OFActionId> DEFAULT_ACTION_IDS = ImmutableList.of();
    private final List<OFActionId> actionIds;
    static final OFTableFeaturePropWriteActionsMissVer15 DEFAULT = new OFTableFeaturePropWriteActionsMissVer15(DEFAULT_ACTION_IDS);
    static final Reader READER = new Reader();
    static final OFTableFeaturePropWriteActionsMissVer15Funnel FUNNEL = new OFTableFeaturePropWriteActionsMissVer15Funnel();
    static final Writer WRITER = new Writer();

    OFTableFeaturePropWriteActionsMissVer15(List<OFActionId> actionIds) {
        if (actionIds == null) {
            throw new NullPointerException("OFTableFeaturePropWriteActionsMissVer15: property actionIds cannot be null");
        }
        this.actionIds = actionIds;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public List<OFActionId> getActionIds() {
        return this.actionIds;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFTableFeaturePropWriteActionsMiss.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableFeaturePropWriteActionsMissVer15(");
        b.append("actionIds=").append(this.actionIds);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableFeaturePropWriteActionsMissVer15 other = (OFTableFeaturePropWriteActionsMissVer15)obj;
        return !(this.actionIds == null ? other.actionIds != null : !this.actionIds.equals(other.actionIds));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionIds == null ? 0 : this.actionIds.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableFeaturePropWriteActionsMissVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFTableFeaturePropWriteActionsMissVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(5);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.actionIds);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFTableFeaturePropWriteActionsMissVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFTableFeaturePropWriteActionsMissVer15Funnel
    implements Funnel<OFTableFeaturePropWriteActionsMissVer15> {
        private static final long serialVersionUID = 1L;

        OFTableFeaturePropWriteActionsMissVer15Funnel() {
        }

        public void funnel(OFTableFeaturePropWriteActionsMissVer15 message, PrimitiveSink sink) {
            sink.putShort((short)5);
            FunnelUtils.putList(message.actionIds, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableFeaturePropWriteActionsMiss> {
        Reader() {
        }

        @Override
        public OFTableFeaturePropWriteActionsMiss readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 5) {
                throw new OFParseError("Wrong type: Expected=0x5(0x5), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFActionId> actionIds = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFActionIdVer15.READER);
            OFTableFeaturePropWriteActionsMissVer15 tableFeaturePropWriteActionsMissVer15 = new OFTableFeaturePropWriteActionsMissVer15(actionIds);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableFeaturePropWriteActionsMissVer15);
            }
            return tableFeaturePropWriteActionsMissVer15;
        }
    }

    static class Builder
    implements OFTableFeaturePropWriteActionsMiss.Builder {
        private boolean actionIdsSet;
        private List<OFActionId> actionIds;

        Builder() {
        }

        @Override
        public int getType() {
            return 5;
        }

        @Override
        public List<OFActionId> getActionIds() {
            return this.actionIds;
        }

        @Override
        public OFTableFeaturePropWriteActionsMiss.Builder setActionIds(List<OFActionId> actionIds) {
            this.actionIds = actionIds;
            this.actionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTableFeaturePropWriteActionsMiss build() {
            List<OFActionId> actionIds;
            List<OFActionId> list = actionIds = this.actionIdsSet ? this.actionIds : DEFAULT_ACTION_IDS;
            if (actionIds == null) {
                throw new NullPointerException("Property actionIds must not be null");
            }
            return new OFTableFeaturePropWriteActionsMissVer15(actionIds);
        }
    }

    static class BuilderWithParent
    implements OFTableFeaturePropWriteActionsMiss.Builder {
        final OFTableFeaturePropWriteActionsMissVer15 parentMessage;
        private boolean actionIdsSet;
        private List<OFActionId> actionIds;

        BuilderWithParent(OFTableFeaturePropWriteActionsMissVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 5;
        }

        @Override
        public List<OFActionId> getActionIds() {
            return this.actionIds;
        }

        @Override
        public OFTableFeaturePropWriteActionsMiss.Builder setActionIds(List<OFActionId> actionIds) {
            this.actionIds = actionIds;
            this.actionIdsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFTableFeaturePropWriteActionsMiss build() {
            List actionIds;
            List list = actionIds = this.actionIdsSet ? this.actionIds : this.parentMessage.actionIds;
            if (actionIds == null) {
                throw new NullPointerException("Property actionIds must not be null");
            }
            return new OFTableFeaturePropWriteActionsMissVer15(actionIds);
        }
    }
}

