/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFQueueDescPropMinRate;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueDescPropMinRateVer15
implements OFQueueDescPropMinRate {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueDescPropMinRateVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final int DEFAULT_RATE = 0;
    private final int rate;
    static final OFQueueDescPropMinRateVer15 DEFAULT = new OFQueueDescPropMinRateVer15(0);
    static final Reader READER = new Reader();
    static final OFQueueDescPropMinRateVer15Funnel FUNNEL = new OFQueueDescPropMinRateVer15Funnel();
    static final Writer WRITER = new Writer();

    OFQueueDescPropMinRateVer15(int rate) {
        this.rate = U16.normalize(rate);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int getRate() {
        return this.rate;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFQueueDescPropMinRate.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueDescPropMinRateVer15(");
        b.append("rate=").append(this.rate);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueDescPropMinRateVer15 other = (OFQueueDescPropMinRateVer15)obj;
        return this.rate == other.rate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rate;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueDescPropMinRateVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFQueueDescPropMinRateVer15 message) {
            bb.writeShort(1);
            bb.writeShort(8);
            bb.writeShort((int)U16.t(message.rate));
            bb.writeZero(2);
        }
    }

    static class OFQueueDescPropMinRateVer15Funnel
    implements Funnel<OFQueueDescPropMinRateVer15> {
        private static final long serialVersionUID = 1L;

        OFQueueDescPropMinRateVer15Funnel() {
        }

        public void funnel(OFQueueDescPropMinRateVer15 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)8);
            sink.putInt(message.rate);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueDescPropMinRate> {
        Reader() {
        }

        @Override
        public OFQueueDescPropMinRate readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int rate = U16.f(bb.readShort());
            bb.skipBytes(2);
            OFQueueDescPropMinRateVer15 queueDescPropMinRateVer15 = new OFQueueDescPropMinRateVer15(rate);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueDescPropMinRateVer15);
            }
            return queueDescPropMinRateVer15;
        }
    }

    static class Builder
    implements OFQueueDescPropMinRate.Builder {
        private boolean rateSet;
        private int rate;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public int getRate() {
            return this.rate;
        }

        @Override
        public OFQueueDescPropMinRate.Builder setRate(int rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFQueueDescPropMinRate build() {
            int rate = this.rateSet ? this.rate : 0;
            return new OFQueueDescPropMinRateVer15(rate);
        }
    }

    static class BuilderWithParent
    implements OFQueueDescPropMinRate.Builder {
        final OFQueueDescPropMinRateVer15 parentMessage;
        private boolean rateSet;
        private int rate;

        BuilderWithParent(OFQueueDescPropMinRateVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public int getRate() {
            return this.rate;
        }

        @Override
        public OFQueueDescPropMinRate.Builder setRate(int rate) {
            this.rate = rate;
            this.rateSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFQueueDescPropMinRate build() {
            int rate = this.rateSet ? this.rate : this.parentMessage.rate;
            return new OFQueueDescPropMinRateVer15(rate);
        }
    }
}

