/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFOxsClass;

public class OFOxsClassSerializerVer15 {
    public static final short OPENFLOW_BASIC_VAL = -32766;
    public static final short EXPERIMENTER_VAL = -1;

    public static OFOxsClass readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFOxsClassSerializerVer15.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFOxsClass e) {
        bb.writeShort((int)OFOxsClassSerializerVer15.toWireValue(e));
    }

    public static void putTo(OFOxsClass e, PrimitiveSink sink) {
        sink.putShort(OFOxsClassSerializerVer15.toWireValue(e));
    }

    public static OFOxsClass ofWireValue(short val) {
        switch (val) {
            case -32766: {
                return OFOxsClass.OPENFLOW_BASIC;
            }
            case -1: {
                return OFOxsClass.EXPERIMENTER;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFOxsClass in version 1.5: " + val);
    }

    public static short toWireValue(OFOxsClass e) {
        switch (e) {
            case OPENFLOW_BASIC: {
                return -32766;
            }
            case EXPERIMENTER: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFOxsClass in version 1.5: " + (Object)((Object)e));
    }
}

