/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6Dst;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpv6DstVer15
implements OFOxmIpv6Dst {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpv6DstVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 20;
    private static final IPv6Address DEFAULT_VALUE = IPv6Address.NONE;
    private final IPv6Address value;
    static final OFOxmIpv6DstVer15 DEFAULT = new OFOxmIpv6DstVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmIpv6DstVer15Funnel FUNNEL = new OFOxmIpv6DstVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpv6DstVer15(IPv6Address value) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpv6DstVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147497488L;
    }

    @Override
    public IPv6Address getValue() {
        return this.value;
    }

    @Override
    public MatchField<IPv6Address> getMatchField() {
        return MatchField.IPV6_DST;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<IPv6Address> getCanonical() {
        return this;
    }

    @Override
    public IPv6Address getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.5");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmIpv6Dst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpv6DstVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpv6DstVer15 other = (OFOxmIpv6DstVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpv6DstVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIpv6DstVer15 message) {
            bb.writeInt(-2147469808);
            message.value.write16Bytes(bb);
        }
    }

    static class OFOxmIpv6DstVer15Funnel
    implements Funnel<OFOxmIpv6DstVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmIpv6DstVer15Funnel() {
        }

        public void funnel(OFOxmIpv6DstVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147469808);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpv6Dst> {
        Reader() {
        }

        @Override
        public OFOxmIpv6Dst readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147469808) {
                throw new OFParseError("Wrong typeLen: Expected=0x80003610L(0x80003610L), got=" + typeLen);
            }
            IPv6Address value = IPv6Address.read16Bytes(bb);
            OFOxmIpv6DstVer15 oxmIpv6DstVer15 = new OFOxmIpv6DstVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpv6DstVer15);
            }
            return oxmIpv6DstVer15;
        }
    }

    static class Builder
    implements OFOxmIpv6Dst.Builder {
        private boolean valueSet;
        private IPv6Address value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147497488L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6Dst.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.IPV6_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public IPv6Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmIpv6Dst build() {
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpv6DstVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpv6Dst.Builder {
        final OFOxmIpv6DstVer15 parentMessage;
        private boolean valueSet;
        private IPv6Address value;

        BuilderWithParent(OFOxmIpv6DstVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147497488L;
        }

        @Override
        public IPv6Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6Dst.Builder setValue(IPv6Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6Address> getMatchField() {
            return MatchField.IPV6_DST;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv6Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public IPv6Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmIpv6Dst build() {
            IPv6Address value;
            IPv6Address iPv6Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpv6DstVer15(value);
        }
    }
}

