/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIcmpv4CodeMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmIcmpv4CodeVer15;
import org.projectfloodlight.openflow.types.ICMPv4Code;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIcmpv4CodeMaskedVer15
implements OFOxmIcmpv4CodeMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIcmpv4CodeMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 6;
    private static final ICMPv4Code DEFAULT_VALUE = ICMPv4Code.NONE;
    private static final ICMPv4Code DEFAULT_VALUE_MASK = ICMPv4Code.NONE;
    private final ICMPv4Code value;
    private final ICMPv4Code mask;
    static final OFOxmIcmpv4CodeMaskedVer15 DEFAULT = new OFOxmIcmpv4CodeMaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmIcmpv4CodeMaskedVer15Funnel FUNNEL = new OFOxmIcmpv4CodeMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIcmpv4CodeMaskedVer15(ICMPv4Code value, ICMPv4Code mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmIcmpv4CodeMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmIcmpv4CodeMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147494146L;
    }

    @Override
    public ICMPv4Code getValue() {
        return this.value;
    }

    @Override
    public ICMPv4Code getMask() {
        return this.mask;
    }

    @Override
    public MatchField<ICMPv4Code> getMatchField() {
        return MatchField.ICMPV4_CODE;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<ICMPv4Code> getCanonical() {
        if (ICMPv4Code.NO_MASK.equals(this.mask)) {
            return new OFOxmIcmpv4CodeVer15(this.value);
        }
        if (ICMPv4Code.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmIcmpv4CodeMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIcmpv4CodeMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIcmpv4CodeMaskedVer15 other = (OFOxmIcmpv4CodeMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIcmpv4CodeMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmIcmpv4CodeMaskedVer15 message) {
            bb.writeInt(-2147473150);
            message.value.writeByte(bb);
            message.mask.writeByte(bb);
        }
    }

    static class OFOxmIcmpv4CodeMaskedVer15Funnel
    implements Funnel<OFOxmIcmpv4CodeMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmIcmpv4CodeMaskedVer15Funnel() {
        }

        public void funnel(OFOxmIcmpv4CodeMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(-2147473150);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIcmpv4CodeMasked> {
        Reader() {
        }

        @Override
        public OFOxmIcmpv4CodeMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147473150) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002902L(0x80002902L), got=" + typeLen);
            }
            ICMPv4Code value = ICMPv4Code.readByte(bb);
            ICMPv4Code mask = ICMPv4Code.readByte(bb);
            OFOxmIcmpv4CodeMaskedVer15 oxmIcmpv4CodeMaskedVer15 = new OFOxmIcmpv4CodeMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIcmpv4CodeMaskedVer15);
            }
            return oxmIcmpv4CodeMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmIcmpv4CodeMasked.Builder {
        private boolean valueSet;
        private ICMPv4Code value;
        private boolean maskSet;
        private ICMPv4Code mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147494146L;
        }

        @Override
        public ICMPv4Code getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv4CodeMasked.Builder setValue(ICMPv4Code value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public ICMPv4Code getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIcmpv4CodeMasked.Builder setMask(ICMPv4Code mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<ICMPv4Code> getMatchField() {
            return MatchField.ICMPV4_CODE;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<ICMPv4Code> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmIcmpv4CodeMasked build() {
            ICMPv4Code mask;
            ICMPv4Code value;
            ICMPv4Code iCMPv4Code = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            ICMPv4Code iCMPv4Code2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIcmpv4CodeMaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmIcmpv4CodeMasked.Builder {
        final OFOxmIcmpv4CodeMaskedVer15 parentMessage;
        private boolean valueSet;
        private ICMPv4Code value;
        private boolean maskSet;
        private ICMPv4Code mask;

        BuilderWithParent(OFOxmIcmpv4CodeMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147494146L;
        }

        @Override
        public ICMPv4Code getValue() {
            return this.value;
        }

        @Override
        public OFOxmIcmpv4CodeMasked.Builder setValue(ICMPv4Code value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public ICMPv4Code getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIcmpv4CodeMasked.Builder setMask(ICMPv4Code mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<ICMPv4Code> getMatchField() {
            return MatchField.ICMPV4_CODE;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<ICMPv4Code> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmIcmpv4CodeMasked build() {
            ICMPv4Code mask;
            ICMPv4Code value;
            ICMPv4Code iCMPv4Code = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            ICMPv4Code iCMPv4Code2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIcmpv4CodeMaskedVer15(value, mask);
        }
    }
}

