/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnVxlanNetworkIdMasked;
import org.projectfloodlight.openflow.protocol.ver15.OFOxmBsnVxlanNetworkIdVer15;
import org.projectfloodlight.openflow.types.VxlanNI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnVxlanNetworkIdMaskedVer15
implements OFOxmBsnVxlanNetworkIdMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnVxlanNetworkIdMaskedVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 12;
    private static final VxlanNI DEFAULT_VALUE = VxlanNI.ZERO;
    private static final VxlanNI DEFAULT_VALUE_MASK = VxlanNI.ZERO;
    private final VxlanNI value;
    private final VxlanNI mask;
    static final OFOxmBsnVxlanNetworkIdMaskedVer15 DEFAULT = new OFOxmBsnVxlanNetworkIdMaskedVer15(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnVxlanNetworkIdMaskedVer15Funnel FUNNEL = new OFOxmBsnVxlanNetworkIdMaskedVer15Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnVxlanNetworkIdMaskedVer15(VxlanNI value, VxlanNI mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnVxlanNetworkIdMaskedVer15: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnVxlanNetworkIdMaskedVer15: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 207624L;
    }

    @Override
    public VxlanNI getValue() {
        return this.value;
    }

    @Override
    public VxlanNI getMask() {
        return this.mask;
    }

    @Override
    public MatchField<VxlanNI> getMatchField() {
        return MatchField.BSN_VXLAN_NETWORK_ID;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<VxlanNI> getCanonical() {
        if (VxlanNI.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnVxlanNetworkIdVer15(this.value);
        }
        if (VxlanNI.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFOxmBsnVxlanNetworkIdMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnVxlanNetworkIdMaskedVer15(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnVxlanNetworkIdMaskedVer15 other = (OFOxmBsnVxlanNetworkIdMaskedVer15)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnVxlanNetworkIdMaskedVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnVxlanNetworkIdMaskedVer15 message) {
            bb.writeInt(207624);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmBsnVxlanNetworkIdMaskedVer15Funnel
    implements Funnel<OFOxmBsnVxlanNetworkIdMaskedVer15> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnVxlanNetworkIdMaskedVer15Funnel() {
        }

        public void funnel(OFOxmBsnVxlanNetworkIdMaskedVer15 message, PrimitiveSink sink) {
            sink.putInt(207624);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnVxlanNetworkIdMasked> {
        Reader() {
        }

        @Override
        public OFOxmBsnVxlanNetworkIdMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 207624) {
                throw new OFParseError("Wrong typeLen: Expected=0x32b08L(0x32b08L), got=" + typeLen);
            }
            VxlanNI value = VxlanNI.read4Bytes(bb);
            VxlanNI mask = VxlanNI.read4Bytes(bb);
            OFOxmBsnVxlanNetworkIdMaskedVer15 oxmBsnVxlanNetworkIdMaskedVer15 = new OFOxmBsnVxlanNetworkIdMaskedVer15(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnVxlanNetworkIdMaskedVer15);
            }
            return oxmBsnVxlanNetworkIdMaskedVer15;
        }
    }

    static class Builder
    implements OFOxmBsnVxlanNetworkIdMasked.Builder {
        private boolean valueSet;
        private VxlanNI value;
        private boolean maskSet;
        private VxlanNI mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 207624L;
        }

        @Override
        public VxlanNI getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVxlanNetworkIdMasked.Builder setValue(VxlanNI value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public VxlanNI getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnVxlanNetworkIdMasked.Builder setMask(VxlanNI mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<VxlanNI> getMatchField() {
            return MatchField.BSN_VXLAN_NETWORK_ID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<VxlanNI> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnVxlanNetworkIdMasked build() {
            VxlanNI mask;
            VxlanNI value;
            VxlanNI vxlanNI = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            VxlanNI vxlanNI2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnVxlanNetworkIdMaskedVer15(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnVxlanNetworkIdMasked.Builder {
        final OFOxmBsnVxlanNetworkIdMaskedVer15 parentMessage;
        private boolean valueSet;
        private VxlanNI value;
        private boolean maskSet;
        private VxlanNI mask;

        BuilderWithParent(OFOxmBsnVxlanNetworkIdMaskedVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 207624L;
        }

        @Override
        public VxlanNI getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnVxlanNetworkIdMasked.Builder setValue(VxlanNI value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public VxlanNI getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnVxlanNetworkIdMasked.Builder setMask(VxlanNI mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<VxlanNI> getMatchField() {
            return MatchField.BSN_VXLAN_NETWORK_ID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<VxlanNI> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.5");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFOxmBsnVxlanNetworkIdMasked build() {
            VxlanNI mask;
            VxlanNI value;
            VxlanNI vxlanNI = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            VxlanNI vxlanNI2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnVxlanNetworkIdMaskedVer15(value, mask);
        }
    }
}

