/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFMeterFeatures;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterFeaturesVer15
implements OFMeterFeatures {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterFeaturesVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 24;
    private static final long DEFAULT_MAX_METER = 0L;
    private static final long DEFAULT_BAND_TYPES = 0L;
    private static final long DEFAULT_CAPABILITIES = 0L;
    private static final short DEFAULT_MAX_BANDS = 0;
    private static final short DEFAULT_MAX_COLOR = 0;
    private static final long DEFAULT_FEATURES = 0L;
    private final long maxMeter;
    private final long bandTypes;
    private final long capabilities;
    private final short maxBands;
    private final short maxColor;
    private final long features;
    static final OFMeterFeaturesVer15 DEFAULT = new OFMeterFeaturesVer15(0L, 0L, 0L, 0, 0, 0L);
    static final Reader READER = new Reader();
    static final OFMeterFeaturesVer15Funnel FUNNEL = new OFMeterFeaturesVer15Funnel();
    static final Writer WRITER = new Writer();

    OFMeterFeaturesVer15(long maxMeter, long bandTypes, long capabilities, short maxBands, short maxColor, long features) {
        this.maxMeter = U32.normalize(maxMeter);
        this.bandTypes = U32.normalize(bandTypes);
        this.capabilities = U32.normalize(capabilities);
        this.maxBands = U8.normalize(maxBands);
        this.maxColor = U8.normalize(maxColor);
        this.features = U32.normalize(features);
    }

    @Override
    public long getMaxMeter() {
        return this.maxMeter;
    }

    @Override
    public long getBandTypes() {
        return this.bandTypes;
    }

    @Override
    public long getCapabilities() {
        return this.capabilities;
    }

    @Override
    public short getMaxBands() {
        return this.maxBands;
    }

    @Override
    public short getMaxColor() {
        return this.maxColor;
    }

    @Override
    public long getFeatures() {
        return this.features;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFMeterFeatures.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterFeaturesVer15(");
        b.append("maxMeter=").append(this.maxMeter);
        b.append(", ");
        b.append("bandTypes=").append(this.bandTypes);
        b.append(", ");
        b.append("capabilities=").append(this.capabilities);
        b.append(", ");
        b.append("maxBands=").append(this.maxBands);
        b.append(", ");
        b.append("maxColor=").append(this.maxColor);
        b.append(", ");
        b.append("features=").append(this.features);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterFeaturesVer15 other = (OFMeterFeaturesVer15)obj;
        if (this.maxMeter != other.maxMeter) {
            return false;
        }
        if (this.bandTypes != other.bandTypes) {
            return false;
        }
        if (this.capabilities != other.capabilities) {
            return false;
        }
        if (this.maxBands != other.maxBands) {
            return false;
        }
        if (this.maxColor != other.maxColor) {
            return false;
        }
        return this.features == other.features;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.maxMeter ^ this.maxMeter >>> 32);
        result = 31 * (int)(this.bandTypes ^ this.bandTypes >>> 32);
        result = 31 * (int)(this.capabilities ^ this.capabilities >>> 32);
        result = 31 * result + this.maxBands;
        result = 31 * result + this.maxColor;
        result = 31 * (int)(this.features ^ this.features >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterFeaturesVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMeterFeaturesVer15 message) {
            bb.writeInt(U32.t(message.maxMeter));
            bb.writeInt(U32.t(message.bandTypes));
            bb.writeInt(U32.t(message.capabilities));
            bb.writeByte((int)U8.t(message.maxBands));
            bb.writeByte((int)U8.t(message.maxColor));
            bb.writeZero(2);
            bb.writeInt(U32.t(message.features));
            bb.writeZero(4);
        }
    }

    static class OFMeterFeaturesVer15Funnel
    implements Funnel<OFMeterFeaturesVer15> {
        private static final long serialVersionUID = 1L;

        OFMeterFeaturesVer15Funnel() {
        }

        public void funnel(OFMeterFeaturesVer15 message, PrimitiveSink sink) {
            sink.putLong(message.maxMeter);
            sink.putLong(message.bandTypes);
            sink.putLong(message.capabilities);
            sink.putShort(message.maxBands);
            sink.putShort(message.maxColor);
            sink.putLong(message.features);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterFeatures> {
        Reader() {
        }

        @Override
        public OFMeterFeatures readFrom(ByteBuf bb) throws OFParseError {
            long maxMeter = U32.f(bb.readInt());
            long bandTypes = U32.f(bb.readInt());
            long capabilities = U32.f(bb.readInt());
            short maxBands = U8.f(bb.readByte());
            short maxColor = U8.f(bb.readByte());
            bb.skipBytes(2);
            long features = U32.f(bb.readInt());
            bb.skipBytes(4);
            OFMeterFeaturesVer15 meterFeaturesVer15 = new OFMeterFeaturesVer15(maxMeter, bandTypes, capabilities, maxBands, maxColor, features);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterFeaturesVer15);
            }
            return meterFeaturesVer15;
        }
    }

    static class Builder
    implements OFMeterFeatures.Builder {
        private boolean maxMeterSet;
        private long maxMeter;
        private boolean bandTypesSet;
        private long bandTypes;
        private boolean capabilitiesSet;
        private long capabilities;
        private boolean maxBandsSet;
        private short maxBands;
        private boolean maxColorSet;
        private short maxColor;
        private boolean featuresSet;
        private long features;

        Builder() {
        }

        @Override
        public long getMaxMeter() {
            return this.maxMeter;
        }

        @Override
        public OFMeterFeatures.Builder setMaxMeter(long maxMeter) {
            this.maxMeter = maxMeter;
            this.maxMeterSet = true;
            return this;
        }

        @Override
        public long getBandTypes() {
            return this.bandTypes;
        }

        @Override
        public OFMeterFeatures.Builder setBandTypes(long bandTypes) {
            this.bandTypes = bandTypes;
            this.bandTypesSet = true;
            return this;
        }

        @Override
        public long getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFMeterFeatures.Builder setCapabilities(long capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public short getMaxBands() {
            return this.maxBands;
        }

        @Override
        public OFMeterFeatures.Builder setMaxBands(short maxBands) {
            this.maxBands = maxBands;
            this.maxBandsSet = true;
            return this;
        }

        @Override
        public short getMaxColor() {
            return this.maxColor;
        }

        @Override
        public OFMeterFeatures.Builder setMaxColor(short maxColor) {
            this.maxColor = maxColor;
            this.maxColorSet = true;
            return this;
        }

        @Override
        public long getFeatures() {
            return this.features;
        }

        @Override
        public OFMeterFeatures.Builder setFeatures(long features) {
            this.features = features;
            this.featuresSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFMeterFeatures build() {
            long maxMeter = this.maxMeterSet ? this.maxMeter : 0L;
            long bandTypes = this.bandTypesSet ? this.bandTypes : 0L;
            long capabilities = this.capabilitiesSet ? this.capabilities : 0L;
            short maxBands = this.maxBandsSet ? this.maxBands : (short)0;
            short maxColor = this.maxColorSet ? this.maxColor : (short)0;
            long features = this.featuresSet ? this.features : 0L;
            return new OFMeterFeaturesVer15(maxMeter, bandTypes, capabilities, maxBands, maxColor, features);
        }
    }

    static class BuilderWithParent
    implements OFMeterFeatures.Builder {
        final OFMeterFeaturesVer15 parentMessage;
        private boolean maxMeterSet;
        private long maxMeter;
        private boolean bandTypesSet;
        private long bandTypes;
        private boolean capabilitiesSet;
        private long capabilities;
        private boolean maxBandsSet;
        private short maxBands;
        private boolean maxColorSet;
        private short maxColor;
        private boolean featuresSet;
        private long features;

        BuilderWithParent(OFMeterFeaturesVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getMaxMeter() {
            return this.maxMeter;
        }

        @Override
        public OFMeterFeatures.Builder setMaxMeter(long maxMeter) {
            this.maxMeter = maxMeter;
            this.maxMeterSet = true;
            return this;
        }

        @Override
        public long getBandTypes() {
            return this.bandTypes;
        }

        @Override
        public OFMeterFeatures.Builder setBandTypes(long bandTypes) {
            this.bandTypes = bandTypes;
            this.bandTypesSet = true;
            return this;
        }

        @Override
        public long getCapabilities() {
            return this.capabilities;
        }

        @Override
        public OFMeterFeatures.Builder setCapabilities(long capabilities) {
            this.capabilities = capabilities;
            this.capabilitiesSet = true;
            return this;
        }

        @Override
        public short getMaxBands() {
            return this.maxBands;
        }

        @Override
        public OFMeterFeatures.Builder setMaxBands(short maxBands) {
            this.maxBands = maxBands;
            this.maxBandsSet = true;
            return this;
        }

        @Override
        public short getMaxColor() {
            return this.maxColor;
        }

        @Override
        public OFMeterFeatures.Builder setMaxColor(short maxColor) {
            this.maxColor = maxColor;
            this.maxColorSet = true;
            return this;
        }

        @Override
        public long getFeatures() {
            return this.features;
        }

        @Override
        public OFMeterFeatures.Builder setFeatures(long features) {
            this.features = features;
            this.featuresSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFMeterFeatures build() {
            long maxMeter = this.maxMeterSet ? this.maxMeter : this.parentMessage.maxMeter;
            long bandTypes = this.bandTypesSet ? this.bandTypes : this.parentMessage.bandTypes;
            long capabilities = this.capabilitiesSet ? this.capabilities : this.parentMessage.capabilities;
            short maxBands = this.maxBandsSet ? this.maxBands : this.parentMessage.maxBands;
            short maxColor = this.maxColorSet ? this.maxColor : this.parentMessage.maxColor;
            long features = this.featuresSet ? this.features : this.parentMessage.features;
            return new OFMeterFeaturesVer15(maxMeter, bandTypes, capabilities, maxBands, maxColor, features);
        }
    }
}

