/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionClearActions;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionClearActionsVer15
implements OFInstructionClearActions {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionClearActionsVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    static final OFInstructionClearActionsVer15 DEFAULT = new OFInstructionClearActionsVer15();
    static final OFInstructionClearActionsVer15 INSTANCE = new OFInstructionClearActionsVer15();
    static final Reader READER = new Reader();
    static final OFInstructionClearActionsVer15Funnel FUNNEL = new OFInstructionClearActionsVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFInstructionClearActionsVer15() {
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.CLEAR_ACTIONS;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFInstructionClearActions.Builder createBuilder() {
        throw new UnsupportedOperationException("OFInstructionClearActionsVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionClearActionsVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionClearActionsVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFInstructionClearActionsVer15 message) {
            bb.writeShort(5);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFInstructionClearActionsVer15Funnel
    implements Funnel<OFInstructionClearActionsVer15> {
        private static final long serialVersionUID = 1L;

        OFInstructionClearActionsVer15Funnel() {
        }

        public void funnel(OFInstructionClearActionsVer15 message, PrimitiveSink sink) {
            sink.putShort((short)5);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionClearActions> {
        Reader() {
        }

        @Override
        public OFInstructionClearActions readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 5) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.CLEAR_ACTIONS(5), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

