/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFHeaderTypeOnf;

public class OFHeaderTypeOnfSerializerVer15 {
    public static final short ETHERNET_VAL = 0;
    public static final short NO_HEADER_VAL = 1;
    public static final short OXM_EXPERIMENTER_VAL = -1;

    public static OFHeaderTypeOnf readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFHeaderTypeOnfSerializerVer15.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFHeaderTypeOnf e) {
        bb.writeShort((int)OFHeaderTypeOnfSerializerVer15.toWireValue(e));
    }

    public static void putTo(OFHeaderTypeOnf e, PrimitiveSink sink) {
        sink.putShort(OFHeaderTypeOnfSerializerVer15.toWireValue(e));
    }

    public static OFHeaderTypeOnf ofWireValue(short val) {
        switch (val) {
            case 0: {
                return OFHeaderTypeOnf.ETHERNET;
            }
            case 1: {
                return OFHeaderTypeOnf.NO_HEADER;
            }
            case -1: {
                return OFHeaderTypeOnf.OXM_EXPERIMENTER;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFHeaderTypeOnf in version 1.5: " + val);
    }

    public static short toWireValue(OFHeaderTypeOnf e) {
        switch (e) {
            case ETHERNET: {
                return 0;
            }
            case NO_HEADER: {
                return 1;
            }
            case OXM_EXPERIMENTER: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFHeaderTypeOnf in version 1.5: " + (Object)((Object)e));
    }
}

