/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFGroupBucket;

public class OFGroupBucketSerializerVer15 {
    public static final int BUCKET_MAX_VAL = -256;
    public static final int BUCKET_FIRST_VAL = -3;
    public static final int BUCKET_LAST_VAL = -2;
    public static final int BUCKET_ALL_VAL = -1;

    public static OFGroupBucket readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFGroupBucketSerializerVer15.ofWireValue(bb.readInt());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFGroupBucket e) {
        bb.writeInt(OFGroupBucketSerializerVer15.toWireValue(e));
    }

    public static void putTo(OFGroupBucket e, PrimitiveSink sink) {
        sink.putInt(OFGroupBucketSerializerVer15.toWireValue(e));
    }

    public static OFGroupBucket ofWireValue(int val) {
        switch (val) {
            case -256: {
                return OFGroupBucket.BUCKET_MAX;
            }
            case -3: {
                return OFGroupBucket.BUCKET_FIRST;
            }
            case -2: {
                return OFGroupBucket.BUCKET_LAST;
            }
            case -1: {
                return OFGroupBucket.BUCKET_ALL;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFGroupBucket in version 1.5: " + val);
    }

    public static int toWireValue(OFGroupBucket e) {
        switch (e) {
            case BUCKET_MAX: {
                return -256;
            }
            case BUCKET_FIRST: {
                return -3;
            }
            case BUCKET_LAST: {
                return -2;
            }
            case BUCKET_ALL: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFGroupBucket in version 1.5: " + (Object)((Object)e));
    }
}

