/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFGroupBucketPropWatchPort;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFGroupBucketPropWatchPortVer15
implements OFGroupBucketPropWatchPort {
    private static final Logger logger = LoggerFactory.getLogger(OFGroupBucketPropWatchPortVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_WATCH = 0L;
    private final long watch;
    static final OFGroupBucketPropWatchPortVer15 DEFAULT = new OFGroupBucketPropWatchPortVer15(0L);
    static final Reader READER = new Reader();
    static final OFGroupBucketPropWatchPortVer15Funnel FUNNEL = new OFGroupBucketPropWatchPortVer15Funnel();
    static final Writer WRITER = new Writer();

    OFGroupBucketPropWatchPortVer15(long watch) {
        this.watch = U32.normalize(watch);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public long getWatch() {
        return this.watch;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFGroupBucketPropWatchPort.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFGroupBucketPropWatchPortVer15(");
        b.append("watch=").append(this.watch);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFGroupBucketPropWatchPortVer15 other = (OFGroupBucketPropWatchPortVer15)obj;
        return this.watch == other.watch;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.watch ^ this.watch >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFGroupBucketPropWatchPortVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFGroupBucketPropWatchPortVer15 message) {
            bb.writeShort(1);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.watch));
        }
    }

    static class OFGroupBucketPropWatchPortVer15Funnel
    implements Funnel<OFGroupBucketPropWatchPortVer15> {
        private static final long serialVersionUID = 1L;

        OFGroupBucketPropWatchPortVer15Funnel() {
        }

        public void funnel(OFGroupBucketPropWatchPortVer15 message, PrimitiveSink sink) {
            sink.putShort((short)1);
            sink.putShort((short)8);
            sink.putLong(message.watch);
        }
    }

    static class Reader
    implements OFMessageReader<OFGroupBucketPropWatchPort> {
        Reader() {
        }

        @Override
        public OFGroupBucketPropWatchPort readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=0x1(0x1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long watch = U32.f(bb.readInt());
            OFGroupBucketPropWatchPortVer15 groupBucketPropWatchPortVer15 = new OFGroupBucketPropWatchPortVer15(watch);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)groupBucketPropWatchPortVer15);
            }
            return groupBucketPropWatchPortVer15;
        }
    }

    static class Builder
    implements OFGroupBucketPropWatchPort.Builder {
        private boolean watchSet;
        private long watch;

        Builder() {
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public long getWatch() {
            return this.watch;
        }

        @Override
        public OFGroupBucketPropWatchPort.Builder setWatch(long watch) {
            this.watch = watch;
            this.watchSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFGroupBucketPropWatchPort build() {
            long watch = this.watchSet ? this.watch : 0L;
            return new OFGroupBucketPropWatchPortVer15(watch);
        }
    }

    static class BuilderWithParent
    implements OFGroupBucketPropWatchPort.Builder {
        final OFGroupBucketPropWatchPortVer15 parentMessage;
        private boolean watchSet;
        private long watch;

        BuilderWithParent(OFGroupBucketPropWatchPortVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public long getWatch() {
            return this.watch;
        }

        @Override
        public OFGroupBucketPropWatchPort.Builder setWatch(long watch) {
            this.watch = watch;
            this.watchSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFGroupBucketPropWatchPort build() {
            long watch = this.watchSet ? this.watch : this.parentMessage.watch;
            return new OFGroupBucketPropWatchPortVer15(watch);
        }
    }
}

