/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowMonitorReplyEntry;
import org.projectfloodlight.openflow.protocol.OFFlowUpdateEvent;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFFlowUpdateEventSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFFlowMonitorReplyEntryVer15
implements OFFlowMonitorReplyEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFFlowMonitorReplyEntryVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 4;
    private final OFFlowUpdateEvent event;
    static final Reader READER = new Reader();
    static final OFFlowMonitorReplyEntryVer15Funnel FUNNEL = new OFFlowMonitorReplyEntryVer15Funnel();
    static final Writer WRITER = new Writer();

    OFFlowMonitorReplyEntryVer15(OFFlowUpdateEvent event) {
        if (event == null) {
            throw new NullPointerException("OFFlowMonitorReplyEntryVer15: property event cannot be null");
        }
        this.event = event;
    }

    @Override
    public OFFlowUpdateEvent getEvent() {
        return this.event;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFFlowMonitorReplyEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFFlowMonitorReplyEntryVer15(");
        b.append("event=").append((Object)this.event);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFFlowMonitorReplyEntryVer15 other = (OFFlowMonitorReplyEntryVer15)obj;
        return !(this.event == null ? other.event != null : !this.event.equals((Object)other.event));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFFlowMonitorReplyEntryVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFFlowMonitorReplyEntryVer15 message) {
            bb.writeShort(4);
            OFFlowUpdateEventSerializerVer15.writeTo(bb, message.event);
        }
    }

    static class OFFlowMonitorReplyEntryVer15Funnel
    implements Funnel<OFFlowMonitorReplyEntryVer15> {
        private static final long serialVersionUID = 1L;

        OFFlowMonitorReplyEntryVer15Funnel() {
        }

        public void funnel(OFFlowMonitorReplyEntryVer15 message, PrimitiveSink sink) {
            sink.putShort((short)4);
            OFFlowUpdateEventSerializerVer15.putTo(message.event, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFFlowMonitorReplyEntry> {
        Reader() {
        }

        @Override
        public OFFlowMonitorReplyEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFFlowUpdateEvent event = OFFlowUpdateEventSerializerVer15.readFrom(bb);
            OFFlowMonitorReplyEntryVer15 flowMonitorReplyEntryVer15 = new OFFlowMonitorReplyEntryVer15(event);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)flowMonitorReplyEntryVer15);
            }
            return flowMonitorReplyEntryVer15;
        }
    }

    static class Builder
    implements OFFlowMonitorReplyEntry.Builder {
        private boolean eventSet;
        private OFFlowUpdateEvent event;

        Builder() {
        }

        @Override
        public OFFlowUpdateEvent getEvent() {
            return this.event;
        }

        @Override
        public OFFlowMonitorReplyEntry.Builder setEvent(OFFlowUpdateEvent event) {
            this.event = event;
            this.eventSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFFlowMonitorReplyEntry build() {
            if (!this.eventSet) {
                throw new IllegalStateException("Property event doesn't have default value -- must be set");
            }
            if (this.event == null) {
                throw new NullPointerException("Property event must not be null");
            }
            return new OFFlowMonitorReplyEntryVer15(this.event);
        }
    }

    static class BuilderWithParent
    implements OFFlowMonitorReplyEntry.Builder {
        final OFFlowMonitorReplyEntryVer15 parentMessage;
        private boolean eventSet;
        private OFFlowUpdateEvent event;

        BuilderWithParent(OFFlowMonitorReplyEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFFlowUpdateEvent getEvent() {
            return this.event;
        }

        @Override
        public OFFlowMonitorReplyEntry.Builder setEvent(OFFlowUpdateEvent event) {
            this.event = event;
            this.eventSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFFlowMonitorReplyEntry build() {
            OFFlowUpdateEvent event;
            OFFlowUpdateEvent oFFlowUpdateEvent = event = this.eventSet ? this.event : this.parentMessage.event;
            if (event == null) {
                throw new NullPointerException("Property event must not be null");
            }
            return new OFFlowMonitorReplyEntryVer15(event);
        }
    }
}

