/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBundleFeatureFlags;
import org.projectfloodlight.openflow.protocol.OFBundleFeaturesProp;
import org.projectfloodlight.openflow.protocol.OFBundleFeaturesStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleFeatureFlagsSerializerVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFBundleFeaturesPropVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFStatsRequestFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBundleFeaturesStatsRequestVer15
implements OFBundleFeaturesStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBundleFeaturesStatsRequestVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 24;
    static final int MAXIMUM_LENGTH = 65535;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final Set<OFBundleFeatureFlags> DEFAULT_FEATURE_REQUEST_FLAGS = ImmutableSet.of();
    private static final List<OFBundleFeaturesProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final Set<OFBundleFeatureFlags> featureRequestFlags;
    private final List<OFBundleFeaturesProp> properties;
    static final OFBundleFeaturesStatsRequestVer15 DEFAULT = new OFBundleFeaturesStatsRequestVer15(0L, DEFAULT_FLAGS, DEFAULT_FEATURE_REQUEST_FLAGS, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFBundleFeaturesStatsRequestVer15Funnel FUNNEL = new OFBundleFeaturesStatsRequestVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBundleFeaturesStatsRequestVer15(long xid, Set<OFStatsRequestFlags> flags, Set<OFBundleFeatureFlags> featureRequestFlags, List<OFBundleFeaturesProp> properties) {
        if (flags == null) {
            throw new NullPointerException("OFBundleFeaturesStatsRequestVer15: property flags cannot be null");
        }
        if (featureRequestFlags == null) {
            throw new NullPointerException("OFBundleFeaturesStatsRequestVer15: property featureRequestFlags cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFBundleFeaturesStatsRequestVer15: property properties cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
        this.featureRequestFlags = featureRequestFlags;
        this.properties = properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.BUNDLE_FEATURES;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public Set<OFBundleFeatureFlags> getFeatureRequestFlags() {
        return this.featureRequestFlags;
    }

    @Override
    public List<OFBundleFeaturesProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFBundleFeaturesStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBundleFeaturesStatsRequestVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("featureRequestFlags=").append(this.featureRequestFlags);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundleFeaturesStatsRequestVer15 other = (OFBundleFeaturesStatsRequestVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.featureRequestFlags == null ? other.featureRequestFlags != null : !this.featureRequestFlags.equals(other.featureRequestFlags)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBundleFeaturesStatsRequestVer15 other = (OFBundleFeaturesStatsRequestVer15)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        if (this.featureRequestFlags == null ? other.featureRequestFlags != null : !this.featureRequestFlags.equals(other.featureRequestFlags)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.featureRequestFlags == null ? 0 : this.featureRequestFlags.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.featureRequestFlags == null ? 0 : this.featureRequestFlags.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBundleFeaturesStatsRequestVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBundleFeaturesStatsRequestVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(6);
            bb.writeByte(18);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(19);
            OFStatsRequestFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeZero(4);
            OFBundleFeatureFlagsSerializerVer15.writeTo(bb, message.featureRequestFlags);
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBundleFeaturesStatsRequestVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBundleFeaturesStatsRequestVer15Funnel
    implements Funnel<OFBundleFeaturesStatsRequestVer15> {
        private static final long serialVersionUID = 1L;

        OFBundleFeaturesStatsRequestVer15Funnel() {
        }

        public void funnel(OFBundleFeaturesStatsRequestVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)18);
            sink.putLong(message.xid);
            sink.putShort((short)19);
            OFStatsRequestFlagsSerializerVer15.putTo(message.flags, sink);
            OFBundleFeatureFlagsSerializerVer15.putTo(message.featureRequestFlags, sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBundleFeaturesStatsRequest> {
        Reader() {
        }

        @Override
        public OFBundleFeaturesStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 24) {
                throw new OFParseError("Wrong length: Expected to be >= 24, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != 19) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.BUNDLE_FEATURES(19), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer15.readFrom(bb);
            bb.skipBytes(4);
            Set<OFBundleFeatureFlags> featureRequestFlags = OFBundleFeatureFlagsSerializerVer15.readFrom(bb);
            bb.skipBytes(4);
            List<OFBundleFeaturesProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBundleFeaturesPropVer15.READER);
            OFBundleFeaturesStatsRequestVer15 bundleFeaturesStatsRequestVer15 = new OFBundleFeaturesStatsRequestVer15(xid, flags, featureRequestFlags, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bundleFeaturesStatsRequestVer15);
            }
            return bundleFeaturesStatsRequestVer15;
        }
    }

    static class Builder
    implements OFBundleFeaturesStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean featureRequestFlagsSet;
        private Set<OFBundleFeatureFlags> featureRequestFlags;
        private boolean propertiesSet;
        private List<OFBundleFeaturesProp> properties;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBundleFeaturesStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.BUNDLE_FEATURES;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBundleFeaturesStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public Set<OFBundleFeatureFlags> getFeatureRequestFlags() {
            return this.featureRequestFlags;
        }

        @Override
        public OFBundleFeaturesStatsRequest.Builder setFeatureRequestFlags(Set<OFBundleFeatureFlags> featureRequestFlags) {
            this.featureRequestFlags = featureRequestFlags;
            this.featureRequestFlagsSet = true;
            return this;
        }

        @Override
        public List<OFBundleFeaturesProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFBundleFeaturesStatsRequest.Builder setProperties(List<OFBundleFeaturesProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFBundleFeaturesStatsRequest build() {
            List<OFBundleFeaturesProp> properties;
            Set<OFBundleFeatureFlags> featureRequestFlags;
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            Set<OFBundleFeatureFlags> set2 = featureRequestFlags = this.featureRequestFlagsSet ? this.featureRequestFlags : DEFAULT_FEATURE_REQUEST_FLAGS;
            if (featureRequestFlags == null) {
                throw new NullPointerException("Property featureRequestFlags must not be null");
            }
            List<OFBundleFeaturesProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFBundleFeaturesStatsRequestVer15(xid, flags, featureRequestFlags, properties);
        }
    }

    static class BuilderWithParent
    implements OFBundleFeaturesStatsRequest.Builder {
        final OFBundleFeaturesStatsRequestVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean featureRequestFlagsSet;
        private Set<OFBundleFeatureFlags> featureRequestFlags;
        private boolean propertiesSet;
        private List<OFBundleFeaturesProp> properties;

        BuilderWithParent(OFBundleFeaturesStatsRequestVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBundleFeaturesStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.BUNDLE_FEATURES;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBundleFeaturesStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public Set<OFBundleFeatureFlags> getFeatureRequestFlags() {
            return this.featureRequestFlags;
        }

        @Override
        public OFBundleFeaturesStatsRequest.Builder setFeatureRequestFlags(Set<OFBundleFeatureFlags> featureRequestFlags) {
            this.featureRequestFlags = featureRequestFlags;
            this.featureRequestFlagsSet = true;
            return this;
        }

        @Override
        public List<OFBundleFeaturesProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFBundleFeaturesStatsRequest.Builder setProperties(List<OFBundleFeaturesProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFBundleFeaturesStatsRequest build() {
            List properties;
            Set featureRequestFlags;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            Set set2 = featureRequestFlags = this.featureRequestFlagsSet ? this.featureRequestFlags : this.parentMessage.featureRequestFlags;
            if (featureRequestFlags == null) {
                throw new NullPointerException("Property featureRequestFlags must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFBundleFeaturesStatsRequestVer15(xid, flags, featureRequestFlags, properties);
        }
    }
}

