/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIpv4Netmask;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIpv4NetmaskVer15
implements OFBsnTlvIpv4Netmask {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIpv4NetmaskVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFBsnTlvIpv4NetmaskVer15 DEFAULT = new OFBsnTlvIpv4NetmaskVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvIpv4NetmaskVer15Funnel FUNNEL = new OFBsnTlvIpv4NetmaskVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIpv4NetmaskVer15(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvIpv4NetmaskVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 60;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvIpv4Netmask.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIpv4NetmaskVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIpv4NetmaskVer15 other = (OFBsnTlvIpv4NetmaskVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIpv4NetmaskVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIpv4NetmaskVer15 message) {
            bb.writeShort(60);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvIpv4NetmaskVer15Funnel
    implements Funnel<OFBsnTlvIpv4NetmaskVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIpv4NetmaskVer15Funnel() {
        }

        public void funnel(OFBsnTlvIpv4NetmaskVer15 message, PrimitiveSink sink) {
            sink.putShort((short)60);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIpv4Netmask> {
        Reader() {
        }

        @Override
        public OFBsnTlvIpv4Netmask readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 60) {
                throw new OFParseError("Wrong type: Expected=0x3c(0x3c), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFBsnTlvIpv4NetmaskVer15 bsnTlvIpv4NetmaskVer15 = new OFBsnTlvIpv4NetmaskVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIpv4NetmaskVer15);
            }
            return bsnTlvIpv4NetmaskVer15;
        }
    }

    static class Builder
    implements OFBsnTlvIpv4Netmask.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public int getType() {
            return 60;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpv4Netmask.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvIpv4Netmask build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpv4NetmaskVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIpv4Netmask.Builder {
        final OFBsnTlvIpv4NetmaskVer15 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFBsnTlvIpv4NetmaskVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 60;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpv4Netmask.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvIpv4Netmask build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvIpv4NetmaskVer15(value);
        }
    }
}

