/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIcmpv6Code;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIcmpv6CodeVer15
implements OFBsnTlvIcmpv6Code {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIcmpv6CodeVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 5;
    private static final short DEFAULT_VALUE = 0;
    private final short value;
    static final OFBsnTlvIcmpv6CodeVer15 DEFAULT = new OFBsnTlvIcmpv6CodeVer15(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvIcmpv6CodeVer15Funnel FUNNEL = new OFBsnTlvIcmpv6CodeVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIcmpv6CodeVer15(short value) {
        this.value = U8.normalize(value);
    }

    @Override
    public int getType() {
        return 205;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvIcmpv6Code.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIcmpv6CodeVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIcmpv6CodeVer15 other = (OFBsnTlvIcmpv6CodeVer15)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIcmpv6CodeVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIcmpv6CodeVer15 message) {
            bb.writeShort(205);
            bb.writeShort(5);
            bb.writeByte((int)U8.t(message.value));
        }
    }

    static class OFBsnTlvIcmpv6CodeVer15Funnel
    implements Funnel<OFBsnTlvIcmpv6CodeVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIcmpv6CodeVer15Funnel() {
        }

        public void funnel(OFBsnTlvIcmpv6CodeVer15 message, PrimitiveSink sink) {
            sink.putShort((short)205);
            sink.putShort((short)5);
            sink.putShort(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIcmpv6Code> {
        Reader() {
        }

        @Override
        public OFBsnTlvIcmpv6Code readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 205) {
                throw new OFParseError("Wrong type: Expected=0xcd(0xcd), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short value = U8.f(bb.readByte());
            OFBsnTlvIcmpv6CodeVer15 bsnTlvIcmpv6CodeVer15 = new OFBsnTlvIcmpv6CodeVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIcmpv6CodeVer15);
            }
            return bsnTlvIcmpv6CodeVer15;
        }
    }

    static class Builder
    implements OFBsnTlvIcmpv6Code.Builder {
        private boolean valueSet;
        private short value;

        Builder() {
        }

        @Override
        public int getType() {
            return 205;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIcmpv6Code.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvIcmpv6Code build() {
            short value = this.valueSet ? this.value : (short)0;
            return new OFBsnTlvIcmpv6CodeVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIcmpv6Code.Builder {
        final OFBsnTlvIcmpv6CodeVer15 parentMessage;
        private boolean valueSet;
        private short value;

        BuilderWithParent(OFBsnTlvIcmpv6CodeVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 205;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIcmpv6Code.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvIcmpv6Code build() {
            short value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvIcmpv6CodeVer15(value);
        }
    }
}

