/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvBucket;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnTlvVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvBucketVer15
implements OFBsnTlvBucket {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvBucketVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final List<OFBsnTlv> DEFAULT_VALUE = ImmutableList.of();
    private final List<OFBsnTlv> value;
    static final OFBsnTlvBucketVer15 DEFAULT = new OFBsnTlvBucketVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvBucketVer15Funnel FUNNEL = new OFBsnTlvBucketVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvBucketVer15(List<OFBsnTlv> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvBucketVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 64;
    }

    @Override
    public List<OFBsnTlv> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvBucket.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvBucketVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvBucketVer15 other = (OFBsnTlvBucketVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvBucketVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvBucketVer15 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(64);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.value);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnTlvBucketVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnTlvBucketVer15Funnel
    implements Funnel<OFBsnTlvBucketVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvBucketVer15Funnel() {
        }

        public void funnel(OFBsnTlvBucketVer15 message, PrimitiveSink sink) {
            sink.putShort((short)64);
            FunnelUtils.putList(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvBucket> {
        Reader() {
        }

        @Override
        public OFBsnTlvBucket readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 64) {
                throw new OFParseError("Wrong type: Expected=0x40(0x40), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFBsnTlv> value = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer15.READER);
            OFBsnTlvBucketVer15 bsnTlvBucketVer15 = new OFBsnTlvBucketVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvBucketVer15);
            }
            return bsnTlvBucketVer15;
        }
    }

    static class Builder
    implements OFBsnTlvBucket.Builder {
        private boolean valueSet;
        private List<OFBsnTlv> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 64;
        }

        @Override
        public List<OFBsnTlv> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBucket.Builder setValue(List<OFBsnTlv> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvBucket build() {
            List<OFBsnTlv> value;
            List<OFBsnTlv> list = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBucketVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvBucket.Builder {
        final OFBsnTlvBucketVer15 parentMessage;
        private boolean valueSet;
        private List<OFBsnTlv> value;

        BuilderWithParent(OFBsnTlvBucketVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 64;
        }

        @Override
        public List<OFBsnTlv> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvBucket.Builder setValue(List<OFBsnTlv> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvBucket build() {
            List value;
            List list = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvBucketVer15(value);
        }
    }
}

