/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvArpSpa;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvArpSpaVer15
implements OFBsnTlvArpSpa {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvArpSpaVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFBsnTlvArpSpaVer15 DEFAULT = new OFBsnTlvArpSpaVer15(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvArpSpaVer15Funnel FUNNEL = new OFBsnTlvArpSpaVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvArpSpaVer15(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvArpSpaVer15: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 199;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnTlvArpSpa.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvArpSpaVer15(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvArpSpaVer15 other = (OFBsnTlvArpSpaVer15)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvArpSpaVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvArpSpaVer15 message) {
            bb.writeShort(199);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvArpSpaVer15Funnel
    implements Funnel<OFBsnTlvArpSpaVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvArpSpaVer15Funnel() {
        }

        public void funnel(OFBsnTlvArpSpaVer15 message, PrimitiveSink sink) {
            sink.putShort((short)199);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvArpSpa> {
        Reader() {
        }

        @Override
        public OFBsnTlvArpSpa readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 199) {
                throw new OFParseError("Wrong type: Expected=0xc7(0xc7), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFBsnTlvArpSpaVer15 bsnTlvArpSpaVer15 = new OFBsnTlvArpSpaVer15(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvArpSpaVer15);
            }
            return bsnTlvArpSpaVer15;
        }
    }

    static class Builder
    implements OFBsnTlvArpSpa.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public int getType() {
            return 199;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvArpSpa.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvArpSpa build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvArpSpaVer15(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvArpSpa.Builder {
        final OFBsnTlvArpSpaVer15 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFBsnTlvArpSpaVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 199;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvArpSpa.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnTlvArpSpa build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvArpSpaVer15(value);
        }
    }
}

