/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnSetLacpReply;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnSetLacpReplyVer15
implements OFBsnSetLacpReply {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnSetLacpReplyVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 24;
    private static final long DEFAULT_XID = 0L;
    private static final long DEFAULT_STATUS = 0L;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private final long xid;
    private final long status;
    private final OFPort portNo;
    static final OFBsnSetLacpReplyVer15 DEFAULT = new OFBsnSetLacpReplyVer15(0L, 0L, DEFAULT_PORT_NO);
    static final Reader READER = new Reader();
    static final OFBsnSetLacpReplyVer15Funnel FUNNEL = new OFBsnSetLacpReplyVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnSetLacpReplyVer15(long xid, long status, OFPort portNo) {
        if (portNo == null) {
            throw new NullPointerException("OFBsnSetLacpReplyVer15: property portNo cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.status = U32.normalize(status);
        this.portNo = portNo;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.EXPERIMENTER;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 42L;
    }

    @Override
    public long getStatus() {
        return this.status;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public OFBsnSetLacpReply.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnSetLacpReplyVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("status=").append(this.status);
        b.append(", ");
        b.append("portNo=").append(this.portNo);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetLacpReplyVer15 other = (OFBsnSetLacpReplyVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.status != other.status) {
            return false;
        }
        return !(this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnSetLacpReplyVer15 other = (OFBsnSetLacpReplyVer15)obj;
        if (this.status != other.status) {
            return false;
        }
        return !(this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * (int)(this.status ^ this.status >>> 32);
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.status ^ this.status >>> 32);
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnSetLacpReplyVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnSetLacpReplyVer15 message) {
            bb.writeByte(6);
            bb.writeByte(4);
            bb.writeShort(24);
            bb.writeInt(U32.t(message.xid));
            bb.writeInt(6035143);
            bb.writeInt(42);
            bb.writeInt(U32.t(message.status));
            message.portNo.write4Bytes(bb);
        }
    }

    static class OFBsnSetLacpReplyVer15Funnel
    implements Funnel<OFBsnSetLacpReplyVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnSetLacpReplyVer15Funnel() {
        }

        public void funnel(OFBsnSetLacpReplyVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)4);
            sink.putShort((short)24);
            sink.putLong(message.xid);
            sink.putInt(6035143);
            sink.putInt(42);
            sink.putLong(message.status);
            message.portNo.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnSetLacpReply> {
        Reader() {
        }

        @Override
        public OFBsnSetLacpReply readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 4) {
                throw new OFParseError("Wrong type: Expected=OFType.EXPERIMENTER(4), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 42) {
                throw new OFParseError("Wrong subtype: Expected=0x2aL(0x2aL), got=" + subtype);
            }
            long status = U32.f(bb.readInt());
            OFPort portNo = OFPort.read4Bytes(bb);
            OFBsnSetLacpReplyVer15 bsnSetLacpReplyVer15 = new OFBsnSetLacpReplyVer15(xid, status, portNo);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnSetLacpReplyVer15);
            }
            return bsnSetLacpReplyVer15;
        }
    }

    static class Builder
    implements OFBsnSetLacpReply.Builder {
        private boolean xidSet;
        private long xid;
        private boolean statusSet;
        private long status;
        private boolean portNoSet;
        private OFPort portNo;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetLacpReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 42L;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnSetLacpReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnSetLacpReply.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public OFBsnSetLacpReply build() {
            OFPort portNo;
            long xid = this.xidSet ? this.xid : 0L;
            long status = this.statusSet ? this.status : 0L;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            return new OFBsnSetLacpReplyVer15(xid, status, portNo);
        }
    }

    static class BuilderWithParent
    implements OFBsnSetLacpReply.Builder {
        final OFBsnSetLacpReplyVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean statusSet;
        private long status;
        private boolean portNoSet;
        private OFPort portNo;

        BuilderWithParent(OFBsnSetLacpReplyVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.EXPERIMENTER;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnSetLacpReply.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 42L;
        }

        @Override
        public long getStatus() {
            return this.status;
        }

        @Override
        public OFBsnSetLacpReply.Builder setStatus(long status) {
            this.status = status;
            this.statusSet = true;
            return this;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFBsnSetLacpReply.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public OFBsnSetLacpReply build() {
            OFPort portNo;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            long status = this.statusSet ? this.status : this.parentMessage.status;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            return new OFBsnSetLacpReplyVer15(xid, status, portNo);
        }
    }
}

