/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnGenericStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlv;
import org.projectfloodlight.openflow.protocol.ver15.OFBsnTlvVer15;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnGenericStatsEntryVer15
implements OFBsnGenericStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnGenericStatsEntryVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 2;
    static final int MAXIMUM_LENGTH = 65535;
    private static final List<OFBsnTlv> DEFAULT_TLVS = ImmutableList.of();
    private final List<OFBsnTlv> tlvs;
    static final OFBsnGenericStatsEntryVer15 DEFAULT = new OFBsnGenericStatsEntryVer15(DEFAULT_TLVS);
    static final Reader READER = new Reader();
    static final OFBsnGenericStatsEntryVer15Funnel FUNNEL = new OFBsnGenericStatsEntryVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnGenericStatsEntryVer15(List<OFBsnTlv> tlvs) {
        if (tlvs == null) {
            throw new NullPointerException("OFBsnGenericStatsEntryVer15: property tlvs cannot be null");
        }
        this.tlvs = tlvs;
    }

    @Override
    public List<OFBsnTlv> getTlvs() {
        return this.tlvs;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFBsnGenericStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnGenericStatsEntryVer15(");
        b.append("tlvs=").append(this.tlvs);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnGenericStatsEntryVer15 other = (OFBsnGenericStatsEntryVer15)obj;
        return !(this.tlvs == null ? other.tlvs != null : !this.tlvs.equals(other.tlvs));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tlvs == null ? 0 : this.tlvs.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnGenericStatsEntryVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnGenericStatsEntryVer15 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            ChannelUtils.writeList(bb, message.tlvs);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnGenericStatsEntryVer15: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnGenericStatsEntryVer15Funnel
    implements Funnel<OFBsnGenericStatsEntryVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnGenericStatsEntryVer15Funnel() {
        }

        public void funnel(OFBsnGenericStatsEntryVer15 message, PrimitiveSink sink) {
            FunnelUtils.putList(message.tlvs, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnGenericStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnGenericStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 2) {
                throw new OFParseError("Wrong length: Expected to be >= 2, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            List<OFBsnTlv> tlvs = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFBsnTlvVer15.READER);
            OFBsnGenericStatsEntryVer15 bsnGenericStatsEntryVer15 = new OFBsnGenericStatsEntryVer15(tlvs);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnGenericStatsEntryVer15);
            }
            return bsnGenericStatsEntryVer15;
        }
    }

    static class Builder
    implements OFBsnGenericStatsEntry.Builder {
        private boolean tlvsSet;
        private List<OFBsnTlv> tlvs;

        Builder() {
        }

        @Override
        public List<OFBsnTlv> getTlvs() {
            return this.tlvs;
        }

        @Override
        public OFBsnGenericStatsEntry.Builder setTlvs(List<OFBsnTlv> tlvs) {
            this.tlvs = tlvs;
            this.tlvsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnGenericStatsEntry build() {
            List<OFBsnTlv> tlvs;
            List<OFBsnTlv> list = tlvs = this.tlvsSet ? this.tlvs : DEFAULT_TLVS;
            if (tlvs == null) {
                throw new NullPointerException("Property tlvs must not be null");
            }
            return new OFBsnGenericStatsEntryVer15(tlvs);
        }
    }

    static class BuilderWithParent
    implements OFBsnGenericStatsEntry.Builder {
        final OFBsnGenericStatsEntryVer15 parentMessage;
        private boolean tlvsSet;
        private List<OFBsnTlv> tlvs;

        BuilderWithParent(OFBsnGenericStatsEntryVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public List<OFBsnTlv> getTlvs() {
            return this.tlvs;
        }

        @Override
        public OFBsnGenericStatsEntry.Builder setTlvs(List<OFBsnTlv> tlvs) {
            this.tlvs = tlvs;
            this.tlvsSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFBsnGenericStatsEntry build() {
            List tlvs;
            List list = tlvs = this.tlvsSet ? this.tlvs : this.parentMessage.tlvs;
            if (tlvs == null) {
                throw new NullPointerException("Property tlvs must not be null");
            }
            return new OFBsnGenericStatsEntryVer15(tlvs);
        }
    }
}

