/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnFlowChecksumBucketStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver15.OFStatsRequestFlagsSerializerVer15;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnFlowChecksumBucketStatsRequestVer15
implements OFBsnFlowChecksumBucketStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnFlowChecksumBucketStatsRequestVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 25;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final TableId tableId;
    static final OFBsnFlowChecksumBucketStatsRequestVer15 DEFAULT = new OFBsnFlowChecksumBucketStatsRequestVer15(0L, DEFAULT_FLAGS, DEFAULT_TABLE_ID);
    static final Reader READER = new Reader();
    static final OFBsnFlowChecksumBucketStatsRequestVer15Funnel FUNNEL = new OFBsnFlowChecksumBucketStatsRequestVer15Funnel();
    static final Writer WRITER = new Writer();

    OFBsnFlowChecksumBucketStatsRequestVer15(long xid, Set<OFStatsRequestFlags> flags, TableId tableId) {
        if (flags == null) {
            throw new NullPointerException("OFBsnFlowChecksumBucketStatsRequestVer15: property flags cannot be null");
        }
        if (tableId == null) {
            throw new NullPointerException("OFBsnFlowChecksumBucketStatsRequestVer15: property tableId cannot be null");
        }
        this.xid = U32.normalize(xid);
        this.flags = flags;
        this.tableId = tableId;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 10L;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public OFBsnFlowChecksumBucketStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnFlowChecksumBucketStatsRequestVer15(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("tableId=").append(this.tableId);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnFlowChecksumBucketStatsRequestVer15 other = (OFBsnFlowChecksumBucketStatsRequestVer15)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId));
    }

    @Override
    public boolean equalsIgnoreXid(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnFlowChecksumBucketStatsRequestVer15 other = (OFBsnFlowChecksumBucketStatsRequestVer15)obj;
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return !(this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        return result;
    }

    @Override
    public int hashCodeIgnoreXid() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnFlowChecksumBucketStatsRequestVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnFlowChecksumBucketStatsRequestVer15 message) {
            bb.writeByte(6);
            bb.writeByte(18);
            bb.writeShort(25);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsRequestFlagsSerializerVer15.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(6035143);
            bb.writeInt(10);
            message.tableId.writeByte(bb);
        }
    }

    static class OFBsnFlowChecksumBucketStatsRequestVer15Funnel
    implements Funnel<OFBsnFlowChecksumBucketStatsRequestVer15> {
        private static final long serialVersionUID = 1L;

        OFBsnFlowChecksumBucketStatsRequestVer15Funnel() {
        }

        public void funnel(OFBsnFlowChecksumBucketStatsRequestVer15 message, PrimitiveSink sink) {
            sink.putByte((byte)6);
            sink.putByte((byte)18);
            sink.putShort((short)25);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsRequestFlagsSerializerVer15.putTo(message.flags, sink);
            sink.putInt(6035143);
            sink.putInt(10);
            message.tableId.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnFlowChecksumBucketStatsRequest> {
        Reader() {
        }

        @Override
        public OFBsnFlowChecksumBucketStatsRequest readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 6) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_15(6), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 25) {
                throw new OFParseError("Wrong length: Expected=25(25), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer15.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 10) {
                throw new OFParseError("Wrong subtype: Expected=0xaL(0xaL), got=" + subtype);
            }
            TableId tableId = TableId.readByte(bb);
            OFBsnFlowChecksumBucketStatsRequestVer15 bsnFlowChecksumBucketStatsRequestVer15 = new OFBsnFlowChecksumBucketStatsRequestVer15(xid, flags, tableId);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnFlowChecksumBucketStatsRequestVer15);
            }
            return bsnFlowChecksumBucketStatsRequestVer15;
        }
    }

    static class Builder
    implements OFBsnFlowChecksumBucketStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean tableIdSet;
        private TableId tableId;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 10L;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsRequest.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsRequest build() {
            TableId tableId;
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            return new OFBsnFlowChecksumBucketStatsRequestVer15(xid, flags, tableId);
        }
    }

    static class BuilderWithParent
    implements OFBsnFlowChecksumBucketStatsRequest.Builder {
        final OFBsnFlowChecksumBucketStatsRequestVer15 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean tableIdSet;
        private TableId tableId;

        BuilderWithParent(OFBsnFlowChecksumBucketStatsRequestVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 10L;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsRequest.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public OFBsnFlowChecksumBucketStatsRequest build() {
            TableId tableId;
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            return new OFBsnFlowChecksumBucketStatsRequestVer15(xid, flags, tableId);
        }
    }
}

