/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnEnhancedHashType;

public class OFBsnEnhancedHashTypeSerializerVer15 {
    public static final long BSN_ENHANCED_HASH_L2_VAL = 1L;
    public static final long BSN_ENHANCED_HASH_L3_VAL = 2L;
    public static final long BSN_ENHANCED_HASH_L2GRE_VAL = 4L;
    public static final long BSN_ENHANCED_HASH_MPLS_VAL = 8L;
    public static final long BSN_ENHANCED_HASH_GTP_VAL = 16L;
    public static final long BSN_ENHANCED_HASH_SYMMETRIC_VAL = 32L;

    public static Set<OFBsnEnhancedHashType> readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFBsnEnhancedHashTypeSerializerVer15.ofWireValue(bb.readLong());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, Set<OFBsnEnhancedHashType> set) {
        bb.writeLong(OFBsnEnhancedHashTypeSerializerVer15.toWireValue(set));
    }

    public static void putTo(Set<OFBsnEnhancedHashType> set, PrimitiveSink sink) {
        sink.putLong(OFBsnEnhancedHashTypeSerializerVer15.toWireValue(set));
    }

    public static Set<OFBsnEnhancedHashType> ofWireValue(long val) {
        EnumSet<OFBsnEnhancedHashType> set = EnumSet.noneOf(OFBsnEnhancedHashType.class);
        if ((val & 1L) != 0L) {
            set.add(OFBsnEnhancedHashType.BSN_ENHANCED_HASH_L2);
        }
        if ((val & 2L) != 0L) {
            set.add(OFBsnEnhancedHashType.BSN_ENHANCED_HASH_L3);
        }
        if ((val & 4L) != 0L) {
            set.add(OFBsnEnhancedHashType.BSN_ENHANCED_HASH_L2GRE);
        }
        if ((val & 8L) != 0L) {
            set.add(OFBsnEnhancedHashType.BSN_ENHANCED_HASH_MPLS);
        }
        if ((val & 0x10L) != 0L) {
            set.add(OFBsnEnhancedHashType.BSN_ENHANCED_HASH_GTP);
        }
        if ((val & 0x20L) != 0L) {
            set.add(OFBsnEnhancedHashType.BSN_ENHANCED_HASH_SYMMETRIC);
        }
        return Collections.unmodifiableSet(set);
    }

    public static long toWireValue(Set<OFBsnEnhancedHashType> set) {
        long wireValue = 0L;
        block8: for (OFBsnEnhancedHashType e : set) {
            switch (e) {
                case BSN_ENHANCED_HASH_L2: {
                    wireValue |= 1L;
                    continue block8;
                }
                case BSN_ENHANCED_HASH_L3: {
                    wireValue |= 2L;
                    continue block8;
                }
                case BSN_ENHANCED_HASH_L2GRE: {
                    wireValue |= 4L;
                    continue block8;
                }
                case BSN_ENHANCED_HASH_MPLS: {
                    wireValue |= 8L;
                    continue block8;
                }
                case BSN_ENHANCED_HASH_GTP: {
                    wireValue |= 0x10L;
                    continue block8;
                }
                case BSN_ENHANCED_HASH_SYMMETRIC: {
                    wireValue |= 0x20L;
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFBsnEnhancedHashType in version 1.5: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

