/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnEncap;

public class OFBsnEncapSerializerVer15 {
    public static final byte BSN_ENCAP_UNUSED_VAL = 0;
    public static final byte BSN_ENCAP_IPV4_UDP_VAL = 1;
    public static final byte BSN_ENCAP_IPV6_UDP_VAL = 2;

    public static OFBsnEncap readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFBsnEncapSerializerVer15.ofWireValue(bb.readByte());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFBsnEncap e) {
        bb.writeByte((int)OFBsnEncapSerializerVer15.toWireValue(e));
    }

    public static void putTo(OFBsnEncap e, PrimitiveSink sink) {
        sink.putByte(OFBsnEncapSerializerVer15.toWireValue(e));
    }

    public static OFBsnEncap ofWireValue(byte val) {
        switch (val) {
            case 0: {
                return OFBsnEncap.BSN_ENCAP_UNUSED;
            }
            case 1: {
                return OFBsnEncap.BSN_ENCAP_IPV4_UDP;
            }
            case 2: {
                return OFBsnEncap.BSN_ENCAP_IPV6_UDP;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFBsnEncap in version 1.5: " + val);
    }

    public static byte toWireValue(OFBsnEncap e) {
        switch (e) {
            case BSN_ENCAP_UNUSED: {
                return 0;
            }
            case BSN_ENCAP_IPV4_UDP: {
                return 1;
            }
            case BSN_ENCAP_IPV6_UDP: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFBsnEncap in version 1.5: " + (Object)((Object)e));
    }
}

