/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFAsyncConfigPropFlowRemovedMaster;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFAsyncConfigPropFlowRemovedMasterVer15
implements OFAsyncConfigPropFlowRemovedMaster {
    private static final Logger logger = LoggerFactory.getLogger(OFAsyncConfigPropFlowRemovedMasterVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    private static final long DEFAULT_MASK = 0L;
    private final long mask;
    static final OFAsyncConfigPropFlowRemovedMasterVer15 DEFAULT = new OFAsyncConfigPropFlowRemovedMasterVer15(0L);
    static final Reader READER = new Reader();
    static final OFAsyncConfigPropFlowRemovedMasterVer15Funnel FUNNEL = new OFAsyncConfigPropFlowRemovedMasterVer15Funnel();
    static final Writer WRITER = new Writer();

    OFAsyncConfigPropFlowRemovedMasterVer15(long mask) {
        this.mask = U32.normalize(mask);
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public long getMask() {
        return this.mask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFAsyncConfigPropFlowRemovedMaster.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFAsyncConfigPropFlowRemovedMasterVer15(");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFAsyncConfigPropFlowRemovedMasterVer15 other = (OFAsyncConfigPropFlowRemovedMasterVer15)obj;
        return this.mask == other.mask;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.mask ^ this.mask >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFAsyncConfigPropFlowRemovedMasterVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFAsyncConfigPropFlowRemovedMasterVer15 message) {
            bb.writeShort(5);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.mask));
        }
    }

    static class OFAsyncConfigPropFlowRemovedMasterVer15Funnel
    implements Funnel<OFAsyncConfigPropFlowRemovedMasterVer15> {
        private static final long serialVersionUID = 1L;

        OFAsyncConfigPropFlowRemovedMasterVer15Funnel() {
        }

        public void funnel(OFAsyncConfigPropFlowRemovedMasterVer15 message, PrimitiveSink sink) {
            sink.putShort((short)5);
            sink.putShort((short)8);
            sink.putLong(message.mask);
        }
    }

    static class Reader
    implements OFMessageReader<OFAsyncConfigPropFlowRemovedMaster> {
        Reader() {
        }

        @Override
        public OFAsyncConfigPropFlowRemovedMaster readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 5) {
                throw new OFParseError("Wrong type: Expected=0x5(0x5), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long mask = U32.f(bb.readInt());
            OFAsyncConfigPropFlowRemovedMasterVer15 asyncConfigPropFlowRemovedMasterVer15 = new OFAsyncConfigPropFlowRemovedMasterVer15(mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)asyncConfigPropFlowRemovedMasterVer15);
            }
            return asyncConfigPropFlowRemovedMasterVer15;
        }
    }

    static class Builder
    implements OFAsyncConfigPropFlowRemovedMaster.Builder {
        private boolean maskSet;
        private long mask;

        Builder() {
        }

        @Override
        public int getType() {
            return 5;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropFlowRemovedMaster.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropFlowRemovedMaster build() {
            long mask = this.maskSet ? this.mask : 0L;
            return new OFAsyncConfigPropFlowRemovedMasterVer15(mask);
        }
    }

    static class BuilderWithParent
    implements OFAsyncConfigPropFlowRemovedMaster.Builder {
        final OFAsyncConfigPropFlowRemovedMasterVer15 parentMessage;
        private boolean maskSet;
        private long mask;

        BuilderWithParent(OFAsyncConfigPropFlowRemovedMasterVer15 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 5;
        }

        @Override
        public long getMask() {
            return this.mask;
        }

        @Override
        public OFAsyncConfigPropFlowRemovedMaster.Builder setMask(long mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_15;
        }

        @Override
        public OFAsyncConfigPropFlowRemovedMaster build() {
            long mask = this.maskSet ? this.mask : this.parentMessage.mask;
            return new OFAsyncConfigPropFlowRemovedMasterVer15(mask);
        }
    }
}

