/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdMeter;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdMeterVer15
implements OFActionIdMeter {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdMeterVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 4;
    static final OFActionIdMeterVer15 DEFAULT = new OFActionIdMeterVer15();
    static final OFActionIdMeterVer15 INSTANCE = new OFActionIdMeterVer15();
    static final Reader READER = new Reader();
    static final OFActionIdMeterVer15Funnel FUNNEL = new OFActionIdMeterVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdMeterVer15() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.METER;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFActionIdMeter.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdMeterVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdMeterVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdMeterVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionIdMeterVer15 message) {
            bb.writeShort(29);
            bb.writeShort(4);
        }
    }

    static class OFActionIdMeterVer15Funnel
    implements Funnel<OFActionIdMeterVer15> {
        private static final long serialVersionUID = 1L;

        OFActionIdMeterVer15Funnel() {
        }

        public void funnel(OFActionIdMeterVer15 message, PrimitiveSink sink) {
            sink.putShort((short)29);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdMeter> {
        Reader() {
        }

        @Override
        public OFActionIdMeter readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 29) {
                throw new OFParseError("Wrong type: Expected=OFActionType.METER(29), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

