/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.action.OFActionExperimenter;
import org.projectfloodlight.openflow.protocol.ver15.OFActionBsnVer15;
import org.projectfloodlight.openflow.protocol.ver15.OFActionNiciraVer15;
import org.projectfloodlight.openflow.types.U16;

abstract class OFActionExperimenterVer15 {
    static final byte WIRE_VERSION = 6;
    static final int MINIMUM_LENGTH = 8;
    public static final Reader READER = new Reader();

    OFActionExperimenterVer15() {
    }

    static class Reader
    implements OFMessageReader<OFActionExperimenter> {
        Reader() {
        }

        @Override
        public OFActionExperimenter readFrom(ByteBuf bb) throws OFParseError {
            if (bb.readableBytes() < 8) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            int experimenter = bb.readInt();
            bb.readerIndex(start);
            switch (experimenter) {
                case 6035143: {
                    return OFActionBsnVer15.READER.readFrom(bb);
                }
                case 8992: {
                    return OFActionNiciraVer15.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator experimenter of class OFActionExperimenterVer15: " + experimenter);
        }
    }
}

