/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver15;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionDecNwTtl;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionDecNwTtlVer15
implements OFActionDecNwTtl {
    private static final Logger logger = LoggerFactory.getLogger(OFActionDecNwTtlVer15.class);
    static final byte WIRE_VERSION = 6;
    static final int LENGTH = 8;
    static final OFActionDecNwTtlVer15 DEFAULT = new OFActionDecNwTtlVer15();
    static final OFActionDecNwTtlVer15 INSTANCE = new OFActionDecNwTtlVer15();
    static final Reader READER = new Reader();
    static final OFActionDecNwTtlVer15Funnel FUNNEL = new OFActionDecNwTtlVer15Funnel();
    static final Writer WRITER = new Writer();

    private OFActionDecNwTtlVer15() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.DEC_NW_TTL;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_15;
    }

    @Override
    public OFActionDecNwTtl.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionDecNwTtlVer15 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionDecNwTtlVer15(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionDecNwTtlVer15> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFActionDecNwTtlVer15 message) {
            bb.writeShort(24);
            bb.writeShort(8);
            bb.writeZero(4);
        }
    }

    static class OFActionDecNwTtlVer15Funnel
    implements Funnel<OFActionDecNwTtlVer15> {
        private static final long serialVersionUID = 1L;

        OFActionDecNwTtlVer15Funnel() {
        }

        public void funnel(OFActionDecNwTtlVer15 message, PrimitiveSink sink) {
            sink.putShort((short)24);
            sink.putShort((short)8);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionDecNwTtl> {
        Reader() {
        }

        @Override
        public OFActionDecNwTtl readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 24) {
                throw new OFParseError("Wrong type: Expected=OFActionType.DEC_NW_TTL(24), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

