/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortStatsEntry;
import org.projectfloodlight.openflow.protocol.OFPortStatsProp;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFPortStatsPropVer14;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortStatsEntryVer14
implements OFPortStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFPortStatsEntryVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 80;
    static final int MAXIMUM_LENGTH = 65535;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final long DEFAULT_DURATION_SEC = 0L;
    private static final long DEFAULT_DURATION_NSEC = 0L;
    private static final U64 DEFAULT_RX_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_RX_BYTES = U64.ZERO;
    private static final U64 DEFAULT_TX_BYTES = U64.ZERO;
    private static final U64 DEFAULT_RX_DROPPED = U64.ZERO;
    private static final U64 DEFAULT_TX_DROPPED = U64.ZERO;
    private static final U64 DEFAULT_RX_ERRORS = U64.ZERO;
    private static final U64 DEFAULT_TX_ERRORS = U64.ZERO;
    private static final List<OFPortStatsProp> DEFAULT_PROPERTIES = ImmutableList.of();
    private final OFPort portNo;
    private final long durationSec;
    private final long durationNsec;
    private final U64 rxPackets;
    private final U64 txPackets;
    private final U64 rxBytes;
    private final U64 txBytes;
    private final U64 rxDropped;
    private final U64 txDropped;
    private final U64 rxErrors;
    private final U64 txErrors;
    private final List<OFPortStatsProp> properties;
    static final OFPortStatsEntryVer14 DEFAULT = new OFPortStatsEntryVer14(DEFAULT_PORT_NO, 0L, 0L, DEFAULT_RX_PACKETS, DEFAULT_TX_PACKETS, DEFAULT_RX_BYTES, DEFAULT_TX_BYTES, DEFAULT_RX_DROPPED, DEFAULT_TX_DROPPED, DEFAULT_RX_ERRORS, DEFAULT_TX_ERRORS, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFPortStatsEntryVer14Funnel FUNNEL = new OFPortStatsEntryVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortStatsEntryVer14(OFPort portNo, long durationSec, long durationNsec, U64 rxPackets, U64 txPackets, U64 rxBytes, U64 txBytes, U64 rxDropped, U64 txDropped, U64 rxErrors, U64 txErrors, List<OFPortStatsProp> properties) {
        if (portNo == null) {
            throw new NullPointerException("OFPortStatsEntryVer14: property portNo cannot be null");
        }
        if (rxPackets == null) {
            throw new NullPointerException("OFPortStatsEntryVer14: property rxPackets cannot be null");
        }
        if (txPackets == null) {
            throw new NullPointerException("OFPortStatsEntryVer14: property txPackets cannot be null");
        }
        if (rxBytes == null) {
            throw new NullPointerException("OFPortStatsEntryVer14: property rxBytes cannot be null");
        }
        if (txBytes == null) {
            throw new NullPointerException("OFPortStatsEntryVer14: property txBytes cannot be null");
        }
        if (rxDropped == null) {
            throw new NullPointerException("OFPortStatsEntryVer14: property rxDropped cannot be null");
        }
        if (txDropped == null) {
            throw new NullPointerException("OFPortStatsEntryVer14: property txDropped cannot be null");
        }
        if (rxErrors == null) {
            throw new NullPointerException("OFPortStatsEntryVer14: property rxErrors cannot be null");
        }
        if (txErrors == null) {
            throw new NullPointerException("OFPortStatsEntryVer14: property txErrors cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFPortStatsEntryVer14: property properties cannot be null");
        }
        this.portNo = portNo;
        this.durationSec = U32.normalize(durationSec);
        this.durationNsec = U32.normalize(durationNsec);
        this.rxPackets = rxPackets;
        this.txPackets = txPackets;
        this.rxBytes = rxBytes;
        this.txBytes = txBytes;
        this.rxDropped = rxDropped;
        this.txDropped = txDropped;
        this.rxErrors = rxErrors;
        this.txErrors = txErrors;
        this.properties = properties;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public U64 getRxPackets() {
        return this.rxPackets;
    }

    @Override
    public U64 getTxPackets() {
        return this.txPackets;
    }

    @Override
    public U64 getRxBytes() {
        return this.rxBytes;
    }

    @Override
    public U64 getTxBytes() {
        return this.txBytes;
    }

    @Override
    public U64 getRxDropped() {
        return this.rxDropped;
    }

    @Override
    public U64 getTxDropped() {
        return this.txDropped;
    }

    @Override
    public U64 getRxErrors() {
        return this.rxErrors;
    }

    @Override
    public U64 getTxErrors() {
        return this.txErrors;
    }

    @Override
    public U64 getRxFrameErr() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property rxFrameErr not supported in version 1.4");
    }

    @Override
    public U64 getRxOverErr() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property rxOverErr not supported in version 1.4");
    }

    @Override
    public U64 getRxCrcErr() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property rxCrcErr not supported in version 1.4");
    }

    @Override
    public U64 getCollisions() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property collisions not supported in version 1.4");
    }

    @Override
    public long getDurationSec() {
        return this.durationSec;
    }

    @Override
    public long getDurationNsec() {
        return this.durationNsec;
    }

    @Override
    public List<OFPortStatsProp> getProperties() {
        return this.properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFPortStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortStatsEntryVer14(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("durationSec=").append(this.durationSec);
        b.append(", ");
        b.append("durationNsec=").append(this.durationNsec);
        b.append(", ");
        b.append("rxPackets=").append(this.rxPackets);
        b.append(", ");
        b.append("txPackets=").append(this.txPackets);
        b.append(", ");
        b.append("rxBytes=").append(this.rxBytes);
        b.append(", ");
        b.append("txBytes=").append(this.txBytes);
        b.append(", ");
        b.append("rxDropped=").append(this.rxDropped);
        b.append(", ");
        b.append("txDropped=").append(this.txDropped);
        b.append(", ");
        b.append("rxErrors=").append(this.rxErrors);
        b.append(", ");
        b.append("txErrors=").append(this.txErrors);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortStatsEntryVer14 other = (OFPortStatsEntryVer14)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.durationSec != other.durationSec) {
            return false;
        }
        if (this.durationNsec != other.durationNsec) {
            return false;
        }
        if (this.rxPackets == null ? other.rxPackets != null : !this.rxPackets.equals(other.rxPackets)) {
            return false;
        }
        if (this.txPackets == null ? other.txPackets != null : !this.txPackets.equals(other.txPackets)) {
            return false;
        }
        if (this.rxBytes == null ? other.rxBytes != null : !this.rxBytes.equals(other.rxBytes)) {
            return false;
        }
        if (this.txBytes == null ? other.txBytes != null : !this.txBytes.equals(other.txBytes)) {
            return false;
        }
        if (this.rxDropped == null ? other.rxDropped != null : !this.rxDropped.equals(other.rxDropped)) {
            return false;
        }
        if (this.txDropped == null ? other.txDropped != null : !this.txDropped.equals(other.txDropped)) {
            return false;
        }
        if (this.rxErrors == null ? other.rxErrors != null : !this.rxErrors.equals(other.rxErrors)) {
            return false;
        }
        if (this.txErrors == null ? other.txErrors != null : !this.txErrors.equals(other.txErrors)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * (int)(this.durationSec ^ this.durationSec >>> 32);
        result = 31 * (int)(this.durationNsec ^ this.durationNsec >>> 32);
        result = 31 * result + (this.rxPackets == null ? 0 : this.rxPackets.hashCode());
        result = 31 * result + (this.txPackets == null ? 0 : this.txPackets.hashCode());
        result = 31 * result + (this.rxBytes == null ? 0 : this.rxBytes.hashCode());
        result = 31 * result + (this.txBytes == null ? 0 : this.txBytes.hashCode());
        result = 31 * result + (this.rxDropped == null ? 0 : this.rxDropped.hashCode());
        result = 31 * result + (this.txDropped == null ? 0 : this.txDropped.hashCode());
        result = 31 * result + (this.rxErrors == null ? 0 : this.rxErrors.hashCode());
        result = 31 * result + (this.txErrors == null ? 0 : this.txErrors.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortStatsEntryVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortStatsEntryVer14 message) {
            int startIndex = bb.writerIndex();
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(2);
            message.portNo.write4Bytes(bb);
            bb.writeInt(U32.t(message.durationSec));
            bb.writeInt(U32.t(message.durationNsec));
            bb.writeLong(message.rxPackets.getValue());
            bb.writeLong(message.txPackets.getValue());
            bb.writeLong(message.rxBytes.getValue());
            bb.writeLong(message.txBytes.getValue());
            bb.writeLong(message.rxDropped.getValue());
            bb.writeLong(message.txDropped.getValue());
            bb.writeLong(message.rxErrors.getValue());
            bb.writeLong(message.txErrors.getValue());
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFPortStatsEntryVer14: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortStatsEntryVer14Funnel
    implements Funnel<OFPortStatsEntryVer14> {
        private static final long serialVersionUID = 1L;

        OFPortStatsEntryVer14Funnel() {
        }

        public void funnel(OFPortStatsEntryVer14 message, PrimitiveSink sink) {
            message.portNo.putTo(sink);
            sink.putLong(message.durationSec);
            sink.putLong(message.durationNsec);
            message.rxPackets.putTo(sink);
            message.txPackets.putTo(sink);
            message.rxBytes.putTo(sink);
            message.txBytes.putTo(sink);
            message.rxDropped.putTo(sink);
            message.txDropped.putTo(sink);
            message.rxErrors.putTo(sink);
            message.txErrors.putTo(sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortStatsEntry> {
        Reader() {
        }

        @Override
        public OFPortStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            int length = U16.f(bb.readShort());
            if (length < 80) {
                throw new OFParseError("Wrong length: Expected to be >= 80, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            OFPort portNo = OFPort.read4Bytes(bb);
            long durationSec = U32.f(bb.readInt());
            long durationNsec = U32.f(bb.readInt());
            U64 rxPackets = U64.ofRaw(bb.readLong());
            U64 txPackets = U64.ofRaw(bb.readLong());
            U64 rxBytes = U64.ofRaw(bb.readLong());
            U64 txBytes = U64.ofRaw(bb.readLong());
            U64 rxDropped = U64.ofRaw(bb.readLong());
            U64 txDropped = U64.ofRaw(bb.readLong());
            U64 rxErrors = U64.ofRaw(bb.readLong());
            U64 txErrors = U64.ofRaw(bb.readLong());
            List<OFPortStatsProp> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFPortStatsPropVer14.READER);
            OFPortStatsEntryVer14 portStatsEntryVer14 = new OFPortStatsEntryVer14(portNo, durationSec, durationNsec, rxPackets, txPackets, rxBytes, txBytes, rxDropped, txDropped, rxErrors, txErrors, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portStatsEntryVer14);
            }
            return portStatsEntryVer14;
        }
    }

    static class Builder
    implements OFPortStatsEntry.Builder {
        private boolean portNoSet;
        private OFPort portNo;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean rxPacketsSet;
        private U64 rxPackets;
        private boolean txPacketsSet;
        private U64 txPackets;
        private boolean rxBytesSet;
        private U64 rxBytes;
        private boolean txBytesSet;
        private U64 txBytes;
        private boolean rxDroppedSet;
        private U64 rxDropped;
        private boolean txDroppedSet;
        private U64 txDropped;
        private boolean rxErrorsSet;
        private U64 rxErrors;
        private boolean txErrorsSet;
        private U64 txErrors;
        private boolean propertiesSet;
        private List<OFPortStatsProp> properties;

        Builder() {
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public U64 getRxPackets() {
            return this.rxPackets;
        }

        @Override
        public OFPortStatsEntry.Builder setRxPackets(U64 rxPackets) {
            this.rxPackets = rxPackets;
            this.rxPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTxPackets() {
            return this.txPackets;
        }

        @Override
        public OFPortStatsEntry.Builder setTxPackets(U64 txPackets) {
            this.txPackets = txPackets;
            this.txPacketsSet = true;
            return this;
        }

        @Override
        public U64 getRxBytes() {
            return this.rxBytes;
        }

        @Override
        public OFPortStatsEntry.Builder setRxBytes(U64 rxBytes) {
            this.rxBytes = rxBytes;
            this.rxBytesSet = true;
            return this;
        }

        @Override
        public U64 getTxBytes() {
            return this.txBytes;
        }

        @Override
        public OFPortStatsEntry.Builder setTxBytes(U64 txBytes) {
            this.txBytes = txBytes;
            this.txBytesSet = true;
            return this;
        }

        @Override
        public U64 getRxDropped() {
            return this.rxDropped;
        }

        @Override
        public OFPortStatsEntry.Builder setRxDropped(U64 rxDropped) {
            this.rxDropped = rxDropped;
            this.rxDroppedSet = true;
            return this;
        }

        @Override
        public U64 getTxDropped() {
            return this.txDropped;
        }

        @Override
        public OFPortStatsEntry.Builder setTxDropped(U64 txDropped) {
            this.txDropped = txDropped;
            this.txDroppedSet = true;
            return this;
        }

        @Override
        public U64 getRxErrors() {
            return this.rxErrors;
        }

        @Override
        public OFPortStatsEntry.Builder setRxErrors(U64 rxErrors) {
            this.rxErrors = rxErrors;
            this.rxErrorsSet = true;
            return this;
        }

        @Override
        public U64 getTxErrors() {
            return this.txErrors;
        }

        @Override
        public OFPortStatsEntry.Builder setTxErrors(U64 txErrors) {
            this.txErrors = txErrors;
            this.txErrorsSet = true;
            return this;
        }

        @Override
        public U64 getRxFrameErr() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property rxFrameErr not supported in version 1.4");
        }

        @Override
        public OFPortStatsEntry.Builder setRxFrameErr(U64 rxFrameErr) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property rxFrameErr not supported in version 1.4");
        }

        @Override
        public U64 getRxOverErr() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property rxOverErr not supported in version 1.4");
        }

        @Override
        public OFPortStatsEntry.Builder setRxOverErr(U64 rxOverErr) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property rxOverErr not supported in version 1.4");
        }

        @Override
        public U64 getRxCrcErr() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property rxCrcErr not supported in version 1.4");
        }

        @Override
        public OFPortStatsEntry.Builder setRxCrcErr(U64 rxCrcErr) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property rxCrcErr not supported in version 1.4");
        }

        @Override
        public U64 getCollisions() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property collisions not supported in version 1.4");
        }

        @Override
        public OFPortStatsEntry.Builder setCollisions(U64 collisions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property collisions not supported in version 1.4");
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFPortStatsEntry.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFPortStatsEntry.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public List<OFPortStatsProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFPortStatsEntry.Builder setProperties(List<OFPortStatsProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortStatsEntry build() {
            List<OFPortStatsProp> properties;
            U64 txErrors;
            U64 rxErrors;
            U64 txDropped;
            U64 rxDropped;
            U64 txBytes;
            U64 rxBytes;
            U64 txPackets;
            U64 rxPackets;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : 0L;
            long durationNsec = this.durationNsecSet ? this.durationNsec : 0L;
            U64 u64 = rxPackets = this.rxPacketsSet ? this.rxPackets : DEFAULT_RX_PACKETS;
            if (rxPackets == null) {
                throw new NullPointerException("Property rxPackets must not be null");
            }
            U64 u642 = txPackets = this.txPacketsSet ? this.txPackets : DEFAULT_TX_PACKETS;
            if (txPackets == null) {
                throw new NullPointerException("Property txPackets must not be null");
            }
            U64 u643 = rxBytes = this.rxBytesSet ? this.rxBytes : DEFAULT_RX_BYTES;
            if (rxBytes == null) {
                throw new NullPointerException("Property rxBytes must not be null");
            }
            U64 u644 = txBytes = this.txBytesSet ? this.txBytes : DEFAULT_TX_BYTES;
            if (txBytes == null) {
                throw new NullPointerException("Property txBytes must not be null");
            }
            U64 u645 = rxDropped = this.rxDroppedSet ? this.rxDropped : DEFAULT_RX_DROPPED;
            if (rxDropped == null) {
                throw new NullPointerException("Property rxDropped must not be null");
            }
            U64 u646 = txDropped = this.txDroppedSet ? this.txDropped : DEFAULT_TX_DROPPED;
            if (txDropped == null) {
                throw new NullPointerException("Property txDropped must not be null");
            }
            U64 u647 = rxErrors = this.rxErrorsSet ? this.rxErrors : DEFAULT_RX_ERRORS;
            if (rxErrors == null) {
                throw new NullPointerException("Property rxErrors must not be null");
            }
            U64 u648 = txErrors = this.txErrorsSet ? this.txErrors : DEFAULT_TX_ERRORS;
            if (txErrors == null) {
                throw new NullPointerException("Property txErrors must not be null");
            }
            List<OFPortStatsProp> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFPortStatsEntryVer14(portNo, durationSec, durationNsec, rxPackets, txPackets, rxBytes, txBytes, rxDropped, txDropped, rxErrors, txErrors, properties);
        }
    }

    static class BuilderWithParent
    implements OFPortStatsEntry.Builder {
        final OFPortStatsEntryVer14 parentMessage;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;
        private boolean rxPacketsSet;
        private U64 rxPackets;
        private boolean txPacketsSet;
        private U64 txPackets;
        private boolean rxBytesSet;
        private U64 rxBytes;
        private boolean txBytesSet;
        private U64 txBytes;
        private boolean rxDroppedSet;
        private U64 rxDropped;
        private boolean txDroppedSet;
        private U64 txDropped;
        private boolean rxErrorsSet;
        private U64 rxErrors;
        private boolean txErrorsSet;
        private U64 txErrors;
        private boolean propertiesSet;
        private List<OFPortStatsProp> properties;

        BuilderWithParent(OFPortStatsEntryVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public U64 getRxPackets() {
            return this.rxPackets;
        }

        @Override
        public OFPortStatsEntry.Builder setRxPackets(U64 rxPackets) {
            this.rxPackets = rxPackets;
            this.rxPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTxPackets() {
            return this.txPackets;
        }

        @Override
        public OFPortStatsEntry.Builder setTxPackets(U64 txPackets) {
            this.txPackets = txPackets;
            this.txPacketsSet = true;
            return this;
        }

        @Override
        public U64 getRxBytes() {
            return this.rxBytes;
        }

        @Override
        public OFPortStatsEntry.Builder setRxBytes(U64 rxBytes) {
            this.rxBytes = rxBytes;
            this.rxBytesSet = true;
            return this;
        }

        @Override
        public U64 getTxBytes() {
            return this.txBytes;
        }

        @Override
        public OFPortStatsEntry.Builder setTxBytes(U64 txBytes) {
            this.txBytes = txBytes;
            this.txBytesSet = true;
            return this;
        }

        @Override
        public U64 getRxDropped() {
            return this.rxDropped;
        }

        @Override
        public OFPortStatsEntry.Builder setRxDropped(U64 rxDropped) {
            this.rxDropped = rxDropped;
            this.rxDroppedSet = true;
            return this;
        }

        @Override
        public U64 getTxDropped() {
            return this.txDropped;
        }

        @Override
        public OFPortStatsEntry.Builder setTxDropped(U64 txDropped) {
            this.txDropped = txDropped;
            this.txDroppedSet = true;
            return this;
        }

        @Override
        public U64 getRxErrors() {
            return this.rxErrors;
        }

        @Override
        public OFPortStatsEntry.Builder setRxErrors(U64 rxErrors) {
            this.rxErrors = rxErrors;
            this.rxErrorsSet = true;
            return this;
        }

        @Override
        public U64 getTxErrors() {
            return this.txErrors;
        }

        @Override
        public OFPortStatsEntry.Builder setTxErrors(U64 txErrors) {
            this.txErrors = txErrors;
            this.txErrorsSet = true;
            return this;
        }

        @Override
        public U64 getRxFrameErr() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property rxFrameErr not supported in version 1.4");
        }

        @Override
        public OFPortStatsEntry.Builder setRxFrameErr(U64 rxFrameErr) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property rxFrameErr not supported in version 1.4");
        }

        @Override
        public U64 getRxOverErr() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property rxOverErr not supported in version 1.4");
        }

        @Override
        public OFPortStatsEntry.Builder setRxOverErr(U64 rxOverErr) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property rxOverErr not supported in version 1.4");
        }

        @Override
        public U64 getRxCrcErr() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property rxCrcErr not supported in version 1.4");
        }

        @Override
        public OFPortStatsEntry.Builder setRxCrcErr(U64 rxCrcErr) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property rxCrcErr not supported in version 1.4");
        }

        @Override
        public U64 getCollisions() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property collisions not supported in version 1.4");
        }

        @Override
        public OFPortStatsEntry.Builder setCollisions(U64 collisions) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property collisions not supported in version 1.4");
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFPortStatsEntry.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFPortStatsEntry.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public List<OFPortStatsProp> getProperties() {
            return this.properties;
        }

        @Override
        public OFPortStatsEntry.Builder setProperties(List<OFPortStatsProp> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortStatsEntry build() {
            List properties;
            U64 txErrors;
            U64 rxErrors;
            U64 txDropped;
            U64 rxDropped;
            U64 txBytes;
            U64 rxBytes;
            U64 txPackets;
            U64 rxPackets;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : this.parentMessage.durationSec;
            long durationNsec = this.durationNsecSet ? this.durationNsec : this.parentMessage.durationNsec;
            U64 u64 = rxPackets = this.rxPacketsSet ? this.rxPackets : this.parentMessage.rxPackets;
            if (rxPackets == null) {
                throw new NullPointerException("Property rxPackets must not be null");
            }
            U64 u642 = txPackets = this.txPacketsSet ? this.txPackets : this.parentMessage.txPackets;
            if (txPackets == null) {
                throw new NullPointerException("Property txPackets must not be null");
            }
            U64 u643 = rxBytes = this.rxBytesSet ? this.rxBytes : this.parentMessage.rxBytes;
            if (rxBytes == null) {
                throw new NullPointerException("Property rxBytes must not be null");
            }
            U64 u644 = txBytes = this.txBytesSet ? this.txBytes : this.parentMessage.txBytes;
            if (txBytes == null) {
                throw new NullPointerException("Property txBytes must not be null");
            }
            U64 u645 = rxDropped = this.rxDroppedSet ? this.rxDropped : this.parentMessage.rxDropped;
            if (rxDropped == null) {
                throw new NullPointerException("Property rxDropped must not be null");
            }
            U64 u646 = txDropped = this.txDroppedSet ? this.txDropped : this.parentMessage.txDropped;
            if (txDropped == null) {
                throw new NullPointerException("Property txDropped must not be null");
            }
            U64 u647 = rxErrors = this.rxErrorsSet ? this.rxErrors : this.parentMessage.rxErrors;
            if (rxErrors == null) {
                throw new NullPointerException("Property rxErrors must not be null");
            }
            U64 u648 = txErrors = this.txErrorsSet ? this.txErrors : this.parentMessage.txErrors;
            if (txErrors == null) {
                throw new NullPointerException("Property txErrors must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFPortStatsEntryVer14(portNo, durationSec, durationNsec, rxPackets, txPackets, rxBytes, txBytes, rxDropped, txDropped, rxErrors, txErrors, properties);
        }
    }
}

