/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortFeatures;
import org.projectfloodlight.openflow.protocol.OFPortModPropEthernet;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver14.OFPortFeaturesSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortModPropEthernetVer14
implements OFPortModPropEthernet {
    private static final Logger logger = LoggerFactory.getLogger(OFPortModPropEthernetVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final Set<OFPortFeatures> DEFAULT_ADVERTISE = ImmutableSet.of();
    private final Set<OFPortFeatures> advertise;
    static final OFPortModPropEthernetVer14 DEFAULT = new OFPortModPropEthernetVer14(DEFAULT_ADVERTISE);
    static final Reader READER = new Reader();
    static final OFPortModPropEthernetVer14Funnel FUNNEL = new OFPortModPropEthernetVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortModPropEthernetVer14(Set<OFPortFeatures> advertise) {
        if (advertise == null) {
            throw new NullPointerException("OFPortModPropEthernetVer14: property advertise cannot be null");
        }
        this.advertise = advertise;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public Set<OFPortFeatures> getAdvertise() {
        return this.advertise;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFPortModPropEthernet.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortModPropEthernetVer14(");
        b.append("advertise=").append(this.advertise);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortModPropEthernetVer14 other = (OFPortModPropEthernetVer14)obj;
        return !(this.advertise == null ? other.advertise != null : !this.advertise.equals(other.advertise));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.advertise == null ? 0 : this.advertise.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortModPropEthernetVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortModPropEthernetVer14 message) {
            bb.writeShort(0);
            bb.writeShort(8);
            OFPortFeaturesSerializerVer14.writeTo(bb, message.advertise);
        }
    }

    static class OFPortModPropEthernetVer14Funnel
    implements Funnel<OFPortModPropEthernetVer14> {
        private static final long serialVersionUID = 1L;

        OFPortModPropEthernetVer14Funnel() {
        }

        public void funnel(OFPortModPropEthernetVer14 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)8);
            OFPortFeaturesSerializerVer14.putTo(message.advertise, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortModPropEthernet> {
        Reader() {
        }

        @Override
        public OFPortModPropEthernet readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFPortFeatures> advertise = OFPortFeaturesSerializerVer14.readFrom(bb);
            OFPortModPropEthernetVer14 portModPropEthernetVer14 = new OFPortModPropEthernetVer14(advertise);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portModPropEthernetVer14);
            }
            return portModPropEthernetVer14;
        }
    }

    static class Builder
    implements OFPortModPropEthernet.Builder {
        private boolean advertiseSet;
        private Set<OFPortFeatures> advertise;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public Set<OFPortFeatures> getAdvertise() {
            return this.advertise;
        }

        @Override
        public OFPortModPropEthernet.Builder setAdvertise(Set<OFPortFeatures> advertise) {
            this.advertise = advertise;
            this.advertiseSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortModPropEthernet build() {
            Set<OFPortFeatures> advertise;
            Set<OFPortFeatures> set = advertise = this.advertiseSet ? this.advertise : DEFAULT_ADVERTISE;
            if (advertise == null) {
                throw new NullPointerException("Property advertise must not be null");
            }
            return new OFPortModPropEthernetVer14(advertise);
        }
    }

    static class BuilderWithParent
    implements OFPortModPropEthernet.Builder {
        final OFPortModPropEthernetVer14 parentMessage;
        private boolean advertiseSet;
        private Set<OFPortFeatures> advertise;

        BuilderWithParent(OFPortModPropEthernetVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public Set<OFPortFeatures> getAdvertise() {
            return this.advertise;
        }

        @Override
        public OFPortModPropEthernet.Builder setAdvertise(Set<OFPortFeatures> advertise) {
            this.advertise = advertise;
            this.advertiseSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortModPropEthernet build() {
            Set advertise;
            Set set = advertise = this.advertiseSet ? this.advertise : this.parentMessage.advertise;
            if (advertise == null) {
                throw new NullPointerException("Property advertise must not be null");
            }
            return new OFPortModPropEthernetVer14(advertise);
        }
    }
}

