/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsnDriverInfoJson;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescPropBsnDriverInfoJsonVer14
implements OFPortDescPropBsnDriverInfoJson {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescPropBsnDriverInfoJsonVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 12;
    static final int MAXIMUM_LENGTH = 65535;
    private static final byte[] DEFAULT_DRIVER_INFO_JSON = new byte[0];
    private final byte[] driverInfoJson;
    static final OFPortDescPropBsnDriverInfoJsonVer14 DEFAULT = new OFPortDescPropBsnDriverInfoJsonVer14(DEFAULT_DRIVER_INFO_JSON);
    static final Reader READER = new Reader();
    static final OFPortDescPropBsnDriverInfoJsonVer14Funnel FUNNEL = new OFPortDescPropBsnDriverInfoJsonVer14Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescPropBsnDriverInfoJsonVer14(byte[] driverInfoJson) {
        if (driverInfoJson == null) {
            throw new NullPointerException("OFPortDescPropBsnDriverInfoJsonVer14: property driverInfoJson cannot be null");
        }
        this.driverInfoJson = driverInfoJson;
    }

    @Override
    public int getType() {
        return 65535;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getExpType() {
        return 7L;
    }

    @Override
    public byte[] getDriverInfoJson() {
        return this.driverInfoJson;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFPortDescPropBsnDriverInfoJson.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescPropBsnDriverInfoJsonVer14(");
        b.append("driverInfoJson=").append(Arrays.toString(this.driverInfoJson));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescPropBsnDriverInfoJsonVer14 other = (OFPortDescPropBsnDriverInfoJsonVer14)obj;
        return Arrays.equals(this.driverInfoJson, other.driverInfoJson);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.driverInfoJson);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescPropBsnDriverInfoJsonVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFPortDescPropBsnDriverInfoJsonVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(-1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(6035143);
            bb.writeInt(7);
            bb.writeBytes(message.driverInfoJson);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFPortDescPropBsnDriverInfoJsonVer14: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortDescPropBsnDriverInfoJsonVer14Funnel
    implements Funnel<OFPortDescPropBsnDriverInfoJsonVer14> {
        private static final long serialVersionUID = 1L;

        OFPortDescPropBsnDriverInfoJsonVer14Funnel() {
        }

        public void funnel(OFPortDescPropBsnDriverInfoJsonVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putInt(6035143);
            sink.putInt(7);
            sink.putBytes(message.driverInfoJson);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsnDriverInfoJson> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsnDriverInfoJson readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            if (expType != 7) {
                throw new OFParseError("Wrong expType: Expected=0x7L(0x7L), got=" + expType);
            }
            byte[] driverInfoJson = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFPortDescPropBsnDriverInfoJsonVer14 portDescPropBsnDriverInfoJsonVer14 = new OFPortDescPropBsnDriverInfoJsonVer14(driverInfoJson);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescPropBsnDriverInfoJsonVer14);
            }
            return portDescPropBsnDriverInfoJsonVer14;
        }
    }

    static class Builder
    implements OFPortDescPropBsnDriverInfoJson.Builder {
        private boolean driverInfoJsonSet;
        private byte[] driverInfoJson;

        Builder() {
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 7L;
        }

        @Override
        public OFPortDescPropBsnDriverInfoJson.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public byte[] getDriverInfoJson() {
            return this.driverInfoJson;
        }

        @Override
        public OFPortDescPropBsnDriverInfoJson.Builder setDriverInfoJson(byte[] driverInfoJson) {
            this.driverInfoJson = driverInfoJson;
            this.driverInfoJsonSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropBsnDriverInfoJson build() {
            byte[] driverInfoJson;
            byte[] byArray = driverInfoJson = this.driverInfoJsonSet ? this.driverInfoJson : DEFAULT_DRIVER_INFO_JSON;
            if (driverInfoJson == null) {
                throw new NullPointerException("Property driverInfoJson must not be null");
            }
            return new OFPortDescPropBsnDriverInfoJsonVer14(driverInfoJson);
        }
    }

    static class BuilderWithParent
    implements OFPortDescPropBsnDriverInfoJson.Builder {
        final OFPortDescPropBsnDriverInfoJsonVer14 parentMessage;
        private boolean driverInfoJsonSet;
        private byte[] driverInfoJson;

        BuilderWithParent(OFPortDescPropBsnDriverInfoJsonVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 65535;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getExpType() {
            return 7L;
        }

        @Override
        public OFPortDescPropBsnDriverInfoJson.Builder setExpType(long expType) {
            throw new UnsupportedOperationException("Property expType is not writeable");
        }

        @Override
        public byte[] getDriverInfoJson() {
            return this.driverInfoJson;
        }

        @Override
        public OFPortDescPropBsnDriverInfoJson.Builder setDriverInfoJson(byte[] driverInfoJson) {
            this.driverInfoJson = driverInfoJson;
            this.driverInfoJsonSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFPortDescPropBsnDriverInfoJson build() {
            byte[] driverInfoJson;
            byte[] byArray = driverInfoJson = this.driverInfoJsonSet ? this.driverInfoJson : this.parentMessage.driverInfoJson;
            if (driverInfoJson == null) {
                throw new NullPointerException("Property driverInfoJson must not be null");
            }
            return new OFPortDescPropBsnDriverInfoJsonVer14(driverInfoJson);
        }
    }
}

