/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEthDstMasked;
import org.projectfloodlight.openflow.protocol.ver14.OFOxmEthDstVer14;
import org.projectfloodlight.openflow.types.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmEthDstMaskedVer14
implements OFOxmEthDstMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmEthDstMaskedVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private static final MacAddress DEFAULT_VALUE_MASK = MacAddress.NONE;
    private final MacAddress value;
    private final MacAddress mask;
    static final OFOxmEthDstMaskedVer14 DEFAULT = new OFOxmEthDstMaskedVer14(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmEthDstMaskedVer14Funnel FUNNEL = new OFOxmEthDstMaskedVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmEthDstMaskedVer14(MacAddress value, MacAddress mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmEthDstMaskedVer14: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmEthDstMaskedVer14: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147485452L;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public MacAddress getMask() {
        return this.mask;
    }

    @Override
    public MatchField<MacAddress> getMatchField() {
        return MatchField.ETH_DST;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<MacAddress> getCanonical() {
        if (MacAddress.NO_MASK.equals(this.mask)) {
            return new OFOxmEthDstVer14(this.value);
        }
        if (MacAddress.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmEthDstMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmEthDstMaskedVer14(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmEthDstMaskedVer14 other = (OFOxmEthDstMaskedVer14)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmEthDstMaskedVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmEthDstMaskedVer14 message) {
            bb.writeInt(-2147481844);
            message.value.write6Bytes(bb);
            message.mask.write6Bytes(bb);
        }
    }

    static class OFOxmEthDstMaskedVer14Funnel
    implements Funnel<OFOxmEthDstMaskedVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmEthDstMaskedVer14Funnel() {
        }

        public void funnel(OFOxmEthDstMaskedVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147481844);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmEthDstMasked> {
        Reader() {
        }

        @Override
        public OFOxmEthDstMasked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147481844) {
                throw new OFParseError("Wrong typeLen: Expected=0x8000070cL(0x8000070cL), got=" + typeLen);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            MacAddress mask = MacAddress.read6Bytes(bb);
            OFOxmEthDstMaskedVer14 oxmEthDstMaskedVer14 = new OFOxmEthDstMaskedVer14(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmEthDstMaskedVer14);
            }
            return oxmEthDstMaskedVer14;
        }
    }

    static class Builder
    implements OFOxmEthDstMasked.Builder {
        private boolean valueSet;
        private MacAddress value;
        private boolean maskSet;
        private MacAddress mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147485452L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmEthDstMasked.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MacAddress getMask() {
            return this.mask;
        }

        @Override
        public OFOxmEthDstMasked.Builder setMask(MacAddress mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.ETH_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmEthDstMasked build() {
            MacAddress mask;
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            MacAddress macAddress2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmEthDstMaskedVer14(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmEthDstMasked.Builder {
        final OFOxmEthDstMaskedVer14 parentMessage;
        private boolean valueSet;
        private MacAddress value;
        private boolean maskSet;
        private MacAddress mask;

        BuilderWithParent(OFOxmEthDstMaskedVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147485452L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmEthDstMasked.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MacAddress getMask() {
            return this.mask;
        }

        @Override
        public OFOxmEthDstMasked.Builder setMask(MacAddress mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.ETH_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmEthDstMasked build() {
            MacAddress mask;
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            MacAddress macAddress2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmEthDstMaskedVer14(value, mask);
        }
    }
}

