/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnUdf4Masked;
import org.projectfloodlight.openflow.protocol.ver14.OFOxmBsnUdf4Ver14;
import org.projectfloodlight.openflow.types.UDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnUdf4MaskedVer14
implements OFOxmBsnUdf4Masked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnUdf4MaskedVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 12;
    private static final UDF DEFAULT_VALUE = UDF.ZERO;
    private static final UDF DEFAULT_VALUE_MASK = UDF.ZERO;
    private final UDF value;
    private final UDF mask;
    static final OFOxmBsnUdf4MaskedVer14 DEFAULT = new OFOxmBsnUdf4MaskedVer14(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnUdf4MaskedVer14Funnel FUNNEL = new OFOxmBsnUdf4MaskedVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnUdf4MaskedVer14(UDF value, UDF mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnUdf4MaskedVer14: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnUdf4MaskedVer14: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 203016L;
    }

    @Override
    public UDF getValue() {
        return this.value;
    }

    @Override
    public UDF getMask() {
        return this.mask;
    }

    @Override
    public MatchField<UDF> getMatchField() {
        return MatchField.BSN_UDF4;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<UDF> getCanonical() {
        if (UDF.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnUdf4Ver14(this.value);
        }
        if (UDF.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmBsnUdf4Masked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnUdf4MaskedVer14(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnUdf4MaskedVer14 other = (OFOxmBsnUdf4MaskedVer14)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnUdf4MaskedVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFOxmBsnUdf4MaskedVer14 message) {
            bb.writeInt(203016);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmBsnUdf4MaskedVer14Funnel
    implements Funnel<OFOxmBsnUdf4MaskedVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnUdf4MaskedVer14Funnel() {
        }

        public void funnel(OFOxmBsnUdf4MaskedVer14 message, PrimitiveSink sink) {
            sink.putInt(203016);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnUdf4Masked> {
        Reader() {
        }

        @Override
        public OFOxmBsnUdf4Masked readFrom(ByteBuf bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 203016) {
                throw new OFParseError("Wrong typeLen: Expected=0x31908L(0x31908L), got=" + typeLen);
            }
            UDF value = UDF.read4Bytes(bb);
            UDF mask = UDF.read4Bytes(bb);
            OFOxmBsnUdf4MaskedVer14 oxmBsnUdf4MaskedVer14 = new OFOxmBsnUdf4MaskedVer14(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnUdf4MaskedVer14);
            }
            return oxmBsnUdf4MaskedVer14;
        }
    }

    static class Builder
    implements OFOxmBsnUdf4Masked.Builder {
        private boolean valueSet;
        private UDF value;
        private boolean maskSet;
        private UDF mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 203016L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf4Masked.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public UDF getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnUdf4Masked.Builder setMask(UDF mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF4;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnUdf4Masked build() {
            UDF mask;
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            UDF uDF2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnUdf4MaskedVer14(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnUdf4Masked.Builder {
        final OFOxmBsnUdf4MaskedVer14 parentMessage;
        private boolean valueSet;
        private UDF value;
        private boolean maskSet;
        private UDF mask;

        BuilderWithParent(OFOxmBsnUdf4MaskedVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 203016L;
        }

        @Override
        public UDF getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnUdf4Masked.Builder setValue(UDF value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public UDF getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnUdf4Masked.Builder setMask(UDF mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<UDF> getMatchField() {
            return MatchField.BSN_UDF4;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<UDF> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmBsnUdf4Masked build() {
            UDF mask;
            UDF value;
            UDF uDF = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            UDF uDF2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnUdf4MaskedVer14(value, mask);
        }
    }
}

