/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMeterBandType;

public class OFMeterBandTypeSerializerVer14 {
    public static final short DROP_VAL = 1;
    public static final short DSCP_REMARK_VAL = 2;
    public static final short EXPERIMENTER_VAL = -1;

    public static OFMeterBandType readFrom(ByteBuf bb) throws OFParseError {
        try {
            return OFMeterBandTypeSerializerVer14.ofWireValue(bb.readShort());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ByteBuf bb, OFMeterBandType e) {
        bb.writeShort((int)OFMeterBandTypeSerializerVer14.toWireValue(e));
    }

    public static void putTo(OFMeterBandType e, PrimitiveSink sink) {
        sink.putShort(OFMeterBandTypeSerializerVer14.toWireValue(e));
    }

    public static OFMeterBandType ofWireValue(short val) {
        switch (val) {
            case 1: {
                return OFMeterBandType.DROP;
            }
            case 2: {
                return OFMeterBandType.DSCP_REMARK;
            }
            case -1: {
                return OFMeterBandType.EXPERIMENTER;
            }
        }
        throw new IllegalArgumentException("Illegal wire value for type OFMeterBandType in version 1.4: " + val);
    }

    public static short toWireValue(OFMeterBandType e) {
        switch (e) {
            case DROP: {
                return 1;
            }
            case DSCP_REMARK: {
                return 2;
            }
            case EXPERIMENTER: {
                return -1;
            }
        }
        throw new IllegalArgumentException("Illegal enum value for type OFMeterBandType in version 1.4: " + (Object)((Object)e));
    }
}

