/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFMeterBandStats;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFMeterBandStatsVer14
implements OFMeterBandStats {
    private static final Logger logger = LoggerFactory.getLogger(OFMeterBandStatsVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    private static final U64 DEFAULT_PACKET_BAND_COUNT = U64.ZERO;
    private static final U64 DEFAULT_BYTE_BAND_COUNT = U64.ZERO;
    private final U64 packetBandCount;
    private final U64 byteBandCount;
    static final OFMeterBandStatsVer14 DEFAULT = new OFMeterBandStatsVer14(DEFAULT_PACKET_BAND_COUNT, DEFAULT_BYTE_BAND_COUNT);
    static final Reader READER = new Reader();
    static final OFMeterBandStatsVer14Funnel FUNNEL = new OFMeterBandStatsVer14Funnel();
    static final Writer WRITER = new Writer();

    OFMeterBandStatsVer14(U64 packetBandCount, U64 byteBandCount) {
        if (packetBandCount == null) {
            throw new NullPointerException("OFMeterBandStatsVer14: property packetBandCount cannot be null");
        }
        if (byteBandCount == null) {
            throw new NullPointerException("OFMeterBandStatsVer14: property byteBandCount cannot be null");
        }
        this.packetBandCount = packetBandCount;
        this.byteBandCount = byteBandCount;
    }

    @Override
    public U64 getPacketBandCount() {
        return this.packetBandCount;
    }

    @Override
    public U64 getByteBandCount() {
        return this.byteBandCount;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFMeterBandStats.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFMeterBandStatsVer14(");
        b.append("packetBandCount=").append(this.packetBandCount);
        b.append(", ");
        b.append("byteBandCount=").append(this.byteBandCount);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFMeterBandStatsVer14 other = (OFMeterBandStatsVer14)obj;
        if (this.packetBandCount == null ? other.packetBandCount != null : !this.packetBandCount.equals(other.packetBandCount)) {
            return false;
        }
        return !(this.byteBandCount == null ? other.byteBandCount != null : !this.byteBandCount.equals(other.byteBandCount));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.packetBandCount == null ? 0 : this.packetBandCount.hashCode());
        result = 31 * result + (this.byteBandCount == null ? 0 : this.byteBandCount.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFMeterBandStatsVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFMeterBandStatsVer14 message) {
            bb.writeLong(message.packetBandCount.getValue());
            bb.writeLong(message.byteBandCount.getValue());
        }
    }

    static class OFMeterBandStatsVer14Funnel
    implements Funnel<OFMeterBandStatsVer14> {
        private static final long serialVersionUID = 1L;

        OFMeterBandStatsVer14Funnel() {
        }

        public void funnel(OFMeterBandStatsVer14 message, PrimitiveSink sink) {
            message.packetBandCount.putTo(sink);
            message.byteBandCount.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFMeterBandStats> {
        Reader() {
        }

        @Override
        public OFMeterBandStats readFrom(ByteBuf bb) throws OFParseError {
            U64 packetBandCount = U64.ofRaw(bb.readLong());
            U64 byteBandCount = U64.ofRaw(bb.readLong());
            OFMeterBandStatsVer14 meterBandStatsVer14 = new OFMeterBandStatsVer14(packetBandCount, byteBandCount);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)meterBandStatsVer14);
            }
            return meterBandStatsVer14;
        }
    }

    static class Builder
    implements OFMeterBandStats.Builder {
        private boolean packetBandCountSet;
        private U64 packetBandCount;
        private boolean byteBandCountSet;
        private U64 byteBandCount;

        Builder() {
        }

        @Override
        public U64 getPacketBandCount() {
            return this.packetBandCount;
        }

        @Override
        public OFMeterBandStats.Builder setPacketBandCount(U64 packetBandCount) {
            this.packetBandCount = packetBandCount;
            this.packetBandCountSet = true;
            return this;
        }

        @Override
        public U64 getByteBandCount() {
            return this.byteBandCount;
        }

        @Override
        public OFMeterBandStats.Builder setByteBandCount(U64 byteBandCount) {
            this.byteBandCount = byteBandCount;
            this.byteBandCountSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFMeterBandStats build() {
            U64 byteBandCount;
            U64 packetBandCount;
            U64 u64 = packetBandCount = this.packetBandCountSet ? this.packetBandCount : DEFAULT_PACKET_BAND_COUNT;
            if (packetBandCount == null) {
                throw new NullPointerException("Property packetBandCount must not be null");
            }
            U64 u642 = byteBandCount = this.byteBandCountSet ? this.byteBandCount : DEFAULT_BYTE_BAND_COUNT;
            if (byteBandCount == null) {
                throw new NullPointerException("Property byteBandCount must not be null");
            }
            return new OFMeterBandStatsVer14(packetBandCount, byteBandCount);
        }
    }

    static class BuilderWithParent
    implements OFMeterBandStats.Builder {
        final OFMeterBandStatsVer14 parentMessage;
        private boolean packetBandCountSet;
        private U64 packetBandCount;
        private boolean byteBandCountSet;
        private U64 byteBandCount;

        BuilderWithParent(OFMeterBandStatsVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U64 getPacketBandCount() {
            return this.packetBandCount;
        }

        @Override
        public OFMeterBandStats.Builder setPacketBandCount(U64 packetBandCount) {
            this.packetBandCount = packetBandCount;
            this.packetBandCountSet = true;
            return this;
        }

        @Override
        public U64 getByteBandCount() {
            return this.byteBandCount;
        }

        @Override
        public OFMeterBandStats.Builder setByteBandCount(U64 byteBandCount) {
            this.byteBandCount = byteBandCount;
            this.byteBandCountSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFMeterBandStats build() {
            U64 byteBandCount;
            U64 packetBandCount;
            U64 u64 = packetBandCount = this.packetBandCountSet ? this.packetBandCount : this.parentMessage.packetBandCount;
            if (packetBandCount == null) {
                throw new NullPointerException("Property packetBandCount must not be null");
            }
            U64 u642 = byteBandCount = this.byteBandCountSet ? this.byteBandCount : this.parentMessage.byteBandCount;
            if (byteBandCount == null) {
                throw new NullPointerException("Property byteBandCount must not be null");
            }
            return new OFMeterBandStatsVer14(packetBandCount, byteBandCount);
        }
    }
}

