/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionBsnInternalPriority;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionBsnInternalPriorityVer14
implements OFInstructionBsnInternalPriority {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionBsnInternalPriorityVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFInstructionBsnInternalPriorityVer14 DEFAULT = new OFInstructionBsnInternalPriorityVer14(0L);
    static final Reader READER = new Reader();
    static final OFInstructionBsnInternalPriorityVer14Funnel FUNNEL = new OFInstructionBsnInternalPriorityVer14Funnel();
    static final Writer WRITER = new Writer();

    OFInstructionBsnInternalPriorityVer14(long value) {
        this.value = U32.normalize(value);
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 12L;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFInstructionBsnInternalPriority.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionBsnInternalPriorityVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFInstructionBsnInternalPriorityVer14 other = (OFInstructionBsnInternalPriorityVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionBsnInternalPriorityVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFInstructionBsnInternalPriorityVer14 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(6035143);
            bb.writeInt(12);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFInstructionBsnInternalPriorityVer14Funnel
    implements Funnel<OFInstructionBsnInternalPriorityVer14> {
        private static final long serialVersionUID = 1L;

        OFInstructionBsnInternalPriorityVer14Funnel() {
        }

        public void funnel(OFInstructionBsnInternalPriorityVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(6035143);
            sink.putInt(12);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionBsnInternalPriority> {
        Reader() {
        }

        @Override
        public OFInstructionBsnInternalPriority readFrom(ByteBuf bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 12) {
                throw new OFParseError("Wrong subtype: Expected=0xcL(0xcL), got=" + subtype);
            }
            long value = U32.f(bb.readInt());
            OFInstructionBsnInternalPriorityVer14 instructionBsnInternalPriorityVer14 = new OFInstructionBsnInternalPriorityVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)instructionBsnInternalPriorityVer14);
            }
            return instructionBsnInternalPriorityVer14;
        }
    }

    static class Builder
    implements OFInstructionBsnInternalPriority.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 12L;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFInstructionBsnInternalPriority.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFInstructionBsnInternalPriority build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFInstructionBsnInternalPriorityVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFInstructionBsnInternalPriority.Builder {
        final OFInstructionBsnInternalPriorityVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFInstructionBsnInternalPriorityVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 12L;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFInstructionBsnInternalPriority.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFInstructionBsnInternalPriority build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFInstructionBsnInternalPriorityVer14(value);
        }
    }
}

