/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUriScheme;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUriSchemeVer14
implements OFBsnTlvUriScheme {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUriSchemeVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    static final int MAXIMUM_LENGTH = 65535;
    private static final byte[] DEFAULT_VALUE = new byte[0];
    private final byte[] value;
    static final OFBsnTlvUriSchemeVer14 DEFAULT = new OFBsnTlvUriSchemeVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvUriSchemeVer14Funnel FUNNEL = new OFBsnTlvUriSchemeVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUriSchemeVer14(byte[] value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvUriSchemeVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 153;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvUriScheme.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUriSchemeVer14(");
        b.append("value=").append(Arrays.toString(this.value));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUriSchemeVer14 other = (OFBsnTlvUriSchemeVer14)obj;
        return Arrays.equals(this.value, other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUriSchemeVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvUriSchemeVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(153);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeBytes(message.value);
            int length = bb.writerIndex() - startIndex;
            if (length > 65535) {
                throw new IllegalArgumentException("OFBsnTlvUriSchemeVer14: message length (" + length + ") exceeds maximum (0xFFFF)");
            }
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnTlvUriSchemeVer14Funnel
    implements Funnel<OFBsnTlvUriSchemeVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUriSchemeVer14Funnel() {
        }

        public void funnel(OFBsnTlvUriSchemeVer14 message, PrimitiveSink sink) {
            sink.putShort((short)153);
            sink.putBytes(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUriScheme> {
        Reader() {
        }

        @Override
        public OFBsnTlvUriScheme readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 153) {
                throw new OFParseError("Wrong type: Expected=0x99(0x99), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            byte[] value = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFBsnTlvUriSchemeVer14 bsnTlvUriSchemeVer14 = new OFBsnTlvUriSchemeVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUriSchemeVer14);
            }
            return bsnTlvUriSchemeVer14;
        }
    }

    static class Builder
    implements OFBsnTlvUriScheme.Builder {
        private boolean valueSet;
        private byte[] value;

        Builder() {
        }

        @Override
        public int getType() {
            return 153;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUriScheme.Builder setValue(byte[] value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvUriScheme build() {
            byte[] value;
            byte[] byArray = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvUriSchemeVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUriScheme.Builder {
        final OFBsnTlvUriSchemeVer14 parentMessage;
        private boolean valueSet;
        private byte[] value;

        BuilderWithParent(OFBsnTlvUriSchemeVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 153;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUriScheme.Builder setValue(byte[] value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvUriScheme build() {
            byte[] value;
            byte[] byArray = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvUriSchemeVer14(value);
        }
    }
}

