/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvUdpDst;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvUdpDstVer14
implements OFBsnTlvUdpDst {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvUdpDstVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvUdpDstVer14 DEFAULT = new OFBsnTlvUdpDstVer14(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvUdpDstVer14Funnel FUNNEL = new OFBsnTlvUdpDstVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvUdpDstVer14(int value) {
        this.value = U16.normalize(value);
    }

    @Override
    public int getType() {
        return 37;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvUdpDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvUdpDstVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvUdpDstVer14 other = (OFBsnTlvUdpDstVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvUdpDstVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvUdpDstVer14 message) {
            bb.writeShort(37);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvUdpDstVer14Funnel
    implements Funnel<OFBsnTlvUdpDstVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvUdpDstVer14Funnel() {
        }

        public void funnel(OFBsnTlvUdpDstVer14 message, PrimitiveSink sink) {
            sink.putShort((short)37);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvUdpDst> {
        Reader() {
        }

        @Override
        public OFBsnTlvUdpDst readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 37) {
                throw new OFParseError("Wrong type: Expected=0x25(0x25), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvUdpDstVer14 bsnTlvUdpDstVer14 = new OFBsnTlvUdpDstVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvUdpDstVer14);
            }
            return bsnTlvUdpDstVer14;
        }
    }

    static class Builder
    implements OFBsnTlvUdpDst.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 37;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUdpDst.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvUdpDst build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvUdpDstVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvUdpDst.Builder {
        final OFBsnTlvUdpDstVer14 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvUdpDstVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 37;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvUdpDst.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvUdpDst build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvUdpDstVer14(value);
        }
    }
}

