/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnTunnelType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvTunnelCapability;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnTunnelTypeSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvTunnelCapabilityVer14
implements OFBsnTlvTunnelCapability {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvTunnelCapabilityVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 12;
    private static final Set<OFBsnTunnelType> DEFAULT_VALUE = ImmutableSet.of();
    private final Set<OFBsnTunnelType> value;
    static final OFBsnTlvTunnelCapabilityVer14 DEFAULT = new OFBsnTlvTunnelCapabilityVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvTunnelCapabilityVer14Funnel FUNNEL = new OFBsnTlvTunnelCapabilityVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvTunnelCapabilityVer14(Set<OFBsnTunnelType> value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvTunnelCapabilityVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 142;
    }

    @Override
    public Set<OFBsnTunnelType> getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvTunnelCapability.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvTunnelCapabilityVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvTunnelCapabilityVer14 other = (OFBsnTlvTunnelCapabilityVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvTunnelCapabilityVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvTunnelCapabilityVer14 message) {
            bb.writeShort(142);
            bb.writeShort(12);
            OFBsnTunnelTypeSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvTunnelCapabilityVer14Funnel
    implements Funnel<OFBsnTlvTunnelCapabilityVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvTunnelCapabilityVer14Funnel() {
        }

        public void funnel(OFBsnTlvTunnelCapabilityVer14 message, PrimitiveSink sink) {
            sink.putShort((short)142);
            sink.putShort((short)12);
            OFBsnTunnelTypeSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvTunnelCapability> {
        Reader() {
        }

        @Override
        public OFBsnTlvTunnelCapability readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 142) {
                throw new OFParseError("Wrong type: Expected=0x8e(0x8e), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            Set<OFBsnTunnelType> value = OFBsnTunnelTypeSerializerVer14.readFrom(bb);
            OFBsnTlvTunnelCapabilityVer14 bsnTlvTunnelCapabilityVer14 = new OFBsnTlvTunnelCapabilityVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvTunnelCapabilityVer14);
            }
            return bsnTlvTunnelCapabilityVer14;
        }
    }

    static class Builder
    implements OFBsnTlvTunnelCapability.Builder {
        private boolean valueSet;
        private Set<OFBsnTunnelType> value;

        Builder() {
        }

        @Override
        public int getType() {
            return 142;
        }

        @Override
        public Set<OFBsnTunnelType> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvTunnelCapability.Builder setValue(Set<OFBsnTunnelType> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvTunnelCapability build() {
            Set<OFBsnTunnelType> value;
            Set<OFBsnTunnelType> set = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvTunnelCapabilityVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvTunnelCapability.Builder {
        final OFBsnTlvTunnelCapabilityVer14 parentMessage;
        private boolean valueSet;
        private Set<OFBsnTunnelType> value;

        BuilderWithParent(OFBsnTlvTunnelCapabilityVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 142;
        }

        @Override
        public Set<OFBsnTunnelType> getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvTunnelCapability.Builder setValue(Set<OFBsnTunnelType> value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvTunnelCapability build() {
            Set value;
            Set set = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvTunnelCapabilityVer14(value);
        }
    }
}

