/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnStatus;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvStatus;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnStatusSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvStatusVer14
implements OFBsnTlvStatus {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvStatusVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private final OFBsnStatus value;
    static final Reader READER = new Reader();
    static final OFBsnTlvStatusVer14Funnel FUNNEL = new OFBsnTlvStatusVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvStatusVer14(OFBsnStatus value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvStatusVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 97;
    }

    @Override
    public OFBsnStatus getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvStatus.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvStatusVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvStatusVer14 other = (OFBsnTlvStatusVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvStatusVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvStatusVer14 message) {
            bb.writeShort(97);
            bb.writeShort(5);
            OFBsnStatusSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvStatusVer14Funnel
    implements Funnel<OFBsnTlvStatusVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvStatusVer14Funnel() {
        }

        public void funnel(OFBsnTlvStatusVer14 message, PrimitiveSink sink) {
            sink.putShort((short)97);
            sink.putShort((short)5);
            OFBsnStatusSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvStatus> {
        Reader() {
        }

        @Override
        public OFBsnTlvStatus readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 97) {
                throw new OFParseError("Wrong type: Expected=0x61(0x61), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnStatus value = OFBsnStatusSerializerVer14.readFrom(bb);
            OFBsnTlvStatusVer14 bsnTlvStatusVer14 = new OFBsnTlvStatusVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvStatusVer14);
            }
            return bsnTlvStatusVer14;
        }
    }

    static class Builder
    implements OFBsnTlvStatus.Builder {
        private boolean valueSet;
        private OFBsnStatus value;

        Builder() {
        }

        @Override
        public int getType() {
            return 97;
        }

        @Override
        public OFBsnStatus getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvStatus.Builder setValue(OFBsnStatus value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvStatus build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvStatusVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvStatus.Builder {
        final OFBsnTlvStatusVer14 parentMessage;
        private boolean valueSet;
        private OFBsnStatus value;

        BuilderWithParent(OFBsnTlvStatusVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 97;
        }

        @Override
        public OFBsnStatus getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvStatus.Builder setValue(OFBsnStatus value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvStatus build() {
            OFBsnStatus value;
            OFBsnStatus oFBsnStatus = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvStatusVer14(value);
        }
    }
}

