/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvOuterSrcMac;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvOuterSrcMacVer14
implements OFBsnTlvOuterSrcMac {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvOuterSrcMacVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFBsnTlvOuterSrcMacVer14 DEFAULT = new OFBsnTlvOuterSrcMacVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvOuterSrcMacVer14Funnel FUNNEL = new OFBsnTlvOuterSrcMacVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvOuterSrcMacVer14(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvOuterSrcMacVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 157;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvOuterSrcMac.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvOuterSrcMacVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvOuterSrcMacVer14 other = (OFBsnTlvOuterSrcMacVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvOuterSrcMacVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvOuterSrcMacVer14 message) {
            bb.writeShort(157);
            bb.writeShort(10);
            message.value.write6Bytes(bb);
        }
    }

    static class OFBsnTlvOuterSrcMacVer14Funnel
    implements Funnel<OFBsnTlvOuterSrcMacVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvOuterSrcMacVer14Funnel() {
        }

        public void funnel(OFBsnTlvOuterSrcMacVer14 message, PrimitiveSink sink) {
            sink.putShort((short)157);
            sink.putShort((short)10);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvOuterSrcMac> {
        Reader() {
        }

        @Override
        public OFBsnTlvOuterSrcMac readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 157) {
                throw new OFParseError("Wrong type: Expected=0x9d(0x9d), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 10) {
                throw new OFParseError("Wrong length: Expected=10(10), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFBsnTlvOuterSrcMacVer14 bsnTlvOuterSrcMacVer14 = new OFBsnTlvOuterSrcMacVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvOuterSrcMacVer14);
            }
            return bsnTlvOuterSrcMacVer14;
        }
    }

    static class Builder
    implements OFBsnTlvOuterSrcMac.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public int getType() {
            return 157;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvOuterSrcMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvOuterSrcMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvOuterSrcMacVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvOuterSrcMac.Builder {
        final OFBsnTlvOuterSrcMacVer14 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFBsnTlvOuterSrcMacVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 157;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvOuterSrcMac.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvOuterSrcMac build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvOuterSrcMacVer14(value);
        }
    }
}

