/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvMplsControlWord;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvMplsControlWordVer14
implements OFBsnTlvMplsControlWord {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvMplsControlWordVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private static final short DEFAULT_VALUE = 0;
    private final short value;
    static final OFBsnTlvMplsControlWordVer14 DEFAULT = new OFBsnTlvMplsControlWordVer14(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvMplsControlWordVer14Funnel FUNNEL = new OFBsnTlvMplsControlWordVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvMplsControlWordVer14(short value) {
        this.value = U8.normalize(value);
    }

    @Override
    public int getType() {
        return 62;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvMplsControlWord.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvMplsControlWordVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvMplsControlWordVer14 other = (OFBsnTlvMplsControlWordVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvMplsControlWordVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvMplsControlWordVer14 message) {
            bb.writeShort(62);
            bb.writeShort(5);
            bb.writeByte((int)U8.t(message.value));
        }
    }

    static class OFBsnTlvMplsControlWordVer14Funnel
    implements Funnel<OFBsnTlvMplsControlWordVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvMplsControlWordVer14Funnel() {
        }

        public void funnel(OFBsnTlvMplsControlWordVer14 message, PrimitiveSink sink) {
            sink.putShort((short)62);
            sink.putShort((short)5);
            sink.putShort(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvMplsControlWord> {
        Reader() {
        }

        @Override
        public OFBsnTlvMplsControlWord readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 62) {
                throw new OFParseError("Wrong type: Expected=0x3e(0x3e), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short value = U8.f(bb.readByte());
            OFBsnTlvMplsControlWordVer14 bsnTlvMplsControlWordVer14 = new OFBsnTlvMplsControlWordVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvMplsControlWordVer14);
            }
            return bsnTlvMplsControlWordVer14;
        }
    }

    static class Builder
    implements OFBsnTlvMplsControlWord.Builder {
        private boolean valueSet;
        private short value;

        Builder() {
        }

        @Override
        public int getType() {
            return 62;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMplsControlWord.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvMplsControlWord build() {
            short value = this.valueSet ? this.value : (short)0;
            return new OFBsnTlvMplsControlWordVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvMplsControlWord.Builder {
        final OFBsnTlvMplsControlWordVer14 parentMessage;
        private boolean valueSet;
        private short value;

        BuilderWithParent(OFBsnTlvMplsControlWordVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 62;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvMplsControlWord.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvMplsControlWord build() {
            short value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvMplsControlWordVer14(value);
        }
    }
}

