/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvLossless;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvLosslessVer14
implements OFBsnTlvLossless {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvLosslessVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 4;
    static final OFBsnTlvLosslessVer14 DEFAULT = new OFBsnTlvLosslessVer14();
    static final OFBsnTlvLosslessVer14 INSTANCE = new OFBsnTlvLosslessVer14();
    static final Reader READER = new Reader();
    static final OFBsnTlvLosslessVer14Funnel FUNNEL = new OFBsnTlvLosslessVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFBsnTlvLosslessVer14() {
    }

    @Override
    public int getType() {
        return 188;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvLossless.Builder createBuilder() {
        throw new UnsupportedOperationException("OFBsnTlvLosslessVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvLosslessVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvLosslessVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvLosslessVer14 message) {
            bb.writeShort(188);
            bb.writeShort(4);
        }
    }

    static class OFBsnTlvLosslessVer14Funnel
    implements Funnel<OFBsnTlvLosslessVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvLosslessVer14Funnel() {
        }

        public void funnel(OFBsnTlvLosslessVer14 message, PrimitiveSink sink) {
            sink.putShort((short)188);
            sink.putShort((short)4);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvLossless> {
        Reader() {
        }

        @Override
        public OFBsnTlvLossless readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 188) {
                throw new OFParseError("Wrong type: Expected=0xbc(0xbc), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 4) {
                throw new OFParseError("Wrong length: Expected=4(4), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

