/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvIpProto;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvIpProtoVer14
implements OFBsnTlvIpProto {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvIpProtoVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private static final short DEFAULT_VALUE = 0;
    private final short value;
    static final OFBsnTlvIpProtoVer14 DEFAULT = new OFBsnTlvIpProtoVer14(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvIpProtoVer14Funnel FUNNEL = new OFBsnTlvIpProtoVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvIpProtoVer14(short value) {
        this.value = U8.normalize(value);
    }

    @Override
    public int getType() {
        return 67;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvIpProto.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvIpProtoVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvIpProtoVer14 other = (OFBsnTlvIpProtoVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvIpProtoVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvIpProtoVer14 message) {
            bb.writeShort(67);
            bb.writeShort(5);
            bb.writeByte((int)U8.t(message.value));
        }
    }

    static class OFBsnTlvIpProtoVer14Funnel
    implements Funnel<OFBsnTlvIpProtoVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvIpProtoVer14Funnel() {
        }

        public void funnel(OFBsnTlvIpProtoVer14 message, PrimitiveSink sink) {
            sink.putShort((short)67);
            sink.putShort((short)5);
            sink.putShort(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvIpProto> {
        Reader() {
        }

        @Override
        public OFBsnTlvIpProto readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 67) {
                throw new OFParseError("Wrong type: Expected=0x43(0x43), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short value = U8.f(bb.readByte());
            OFBsnTlvIpProtoVer14 bsnTlvIpProtoVer14 = new OFBsnTlvIpProtoVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvIpProtoVer14);
            }
            return bsnTlvIpProtoVer14;
        }
    }

    static class Builder
    implements OFBsnTlvIpProto.Builder {
        private boolean valueSet;
        private short value;

        Builder() {
        }

        @Override
        public int getType() {
            return 67;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpProto.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIpProto build() {
            short value = this.valueSet ? this.value : (short)0;
            return new OFBsnTlvIpProtoVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvIpProto.Builder {
        final OFBsnTlvIpProtoVer14 parentMessage;
        private boolean valueSet;
        private short value;

        BuilderWithParent(OFBsnTlvIpProtoVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 67;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvIpProto.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvIpProto build() {
            short value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvIpProtoVer14(value);
        }
    }
}

