/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvHashSeed;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvHashSeedVer14
implements OFBsnTlvHashSeed {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvHashSeedVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 12;
    private static final long DEFAULT_SEED1 = 0L;
    private static final long DEFAULT_SEED2 = 0L;
    private final long seed1;
    private final long seed2;
    static final OFBsnTlvHashSeedVer14 DEFAULT = new OFBsnTlvHashSeedVer14(0L, 0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvHashSeedVer14Funnel FUNNEL = new OFBsnTlvHashSeedVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvHashSeedVer14(long seed1, long seed2) {
        this.seed1 = U32.normalize(seed1);
        this.seed2 = U32.normalize(seed2);
    }

    @Override
    public int getType() {
        return 100;
    }

    @Override
    public long getSeed1() {
        return this.seed1;
    }

    @Override
    public long getSeed2() {
        return this.seed2;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvHashSeed.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvHashSeedVer14(");
        b.append("seed1=").append(this.seed1);
        b.append(", ");
        b.append("seed2=").append(this.seed2);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvHashSeedVer14 other = (OFBsnTlvHashSeedVer14)obj;
        if (this.seed1 != other.seed1) {
            return false;
        }
        return this.seed2 == other.seed2;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.seed1 ^ this.seed1 >>> 32);
        result = 31 * (int)(this.seed2 ^ this.seed2 >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvHashSeedVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvHashSeedVer14 message) {
            bb.writeShort(100);
            bb.writeShort(12);
            bb.writeInt(U32.t(message.seed1));
            bb.writeInt(U32.t(message.seed2));
        }
    }

    static class OFBsnTlvHashSeedVer14Funnel
    implements Funnel<OFBsnTlvHashSeedVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvHashSeedVer14Funnel() {
        }

        public void funnel(OFBsnTlvHashSeedVer14 message, PrimitiveSink sink) {
            sink.putShort((short)100);
            sink.putShort((short)12);
            sink.putLong(message.seed1);
            sink.putLong(message.seed2);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvHashSeed> {
        Reader() {
        }

        @Override
        public OFBsnTlvHashSeed readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 100) {
                throw new OFParseError("Wrong type: Expected=0x64(0x64), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long seed1 = U32.f(bb.readInt());
            long seed2 = U32.f(bb.readInt());
            OFBsnTlvHashSeedVer14 bsnTlvHashSeedVer14 = new OFBsnTlvHashSeedVer14(seed1, seed2);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvHashSeedVer14);
            }
            return bsnTlvHashSeedVer14;
        }
    }

    static class Builder
    implements OFBsnTlvHashSeed.Builder {
        private boolean seed1Set;
        private long seed1;
        private boolean seed2Set;
        private long seed2;

        Builder() {
        }

        @Override
        public int getType() {
            return 100;
        }

        @Override
        public long getSeed1() {
            return this.seed1;
        }

        @Override
        public OFBsnTlvHashSeed.Builder setSeed1(long seed1) {
            this.seed1 = seed1;
            this.seed1Set = true;
            return this;
        }

        @Override
        public long getSeed2() {
            return this.seed2;
        }

        @Override
        public OFBsnTlvHashSeed.Builder setSeed2(long seed2) {
            this.seed2 = seed2;
            this.seed2Set = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvHashSeed build() {
            long seed1 = this.seed1Set ? this.seed1 : 0L;
            long seed2 = this.seed2Set ? this.seed2 : 0L;
            return new OFBsnTlvHashSeedVer14(seed1, seed2);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvHashSeed.Builder {
        final OFBsnTlvHashSeedVer14 parentMessage;
        private boolean seed1Set;
        private long seed1;
        private boolean seed2Set;
        private long seed2;

        BuilderWithParent(OFBsnTlvHashSeedVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 100;
        }

        @Override
        public long getSeed1() {
            return this.seed1;
        }

        @Override
        public OFBsnTlvHashSeed.Builder setSeed1(long seed1) {
            this.seed1 = seed1;
            this.seed1Set = true;
            return this;
        }

        @Override
        public long getSeed2() {
            return this.seed2;
        }

        @Override
        public OFBsnTlvHashSeed.Builder setSeed2(long seed2) {
            this.seed2 = seed2;
            this.seed2Set = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvHashSeed build() {
            long seed1 = this.seed1Set ? this.seed1 : this.parentMessage.seed1;
            long seed2 = this.seed2Set ? this.seed2 : this.parentMessage.seed2;
            return new OFBsnTlvHashSeedVer14(seed1, seed2);
        }
    }
}

