/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnHashPacketType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvHashPacketType;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnHashPacketTypeSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvHashPacketTypeVer14
implements OFBsnTlvHashPacketType {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvHashPacketTypeVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private final OFBsnHashPacketType value;
    static final Reader READER = new Reader();
    static final OFBsnTlvHashPacketTypeVer14Funnel FUNNEL = new OFBsnTlvHashPacketTypeVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvHashPacketTypeVer14(OFBsnHashPacketType value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvHashPacketTypeVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 102;
    }

    @Override
    public OFBsnHashPacketType getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvHashPacketType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvHashPacketTypeVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvHashPacketTypeVer14 other = (OFBsnTlvHashPacketTypeVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvHashPacketTypeVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvHashPacketTypeVer14 message) {
            bb.writeShort(102);
            bb.writeShort(5);
            OFBsnHashPacketTypeSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvHashPacketTypeVer14Funnel
    implements Funnel<OFBsnTlvHashPacketTypeVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvHashPacketTypeVer14Funnel() {
        }

        public void funnel(OFBsnTlvHashPacketTypeVer14 message, PrimitiveSink sink) {
            sink.putShort((short)102);
            sink.putShort((short)5);
            OFBsnHashPacketTypeSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvHashPacketType> {
        Reader() {
        }

        @Override
        public OFBsnTlvHashPacketType readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 102) {
                throw new OFParseError("Wrong type: Expected=0x66(0x66), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnHashPacketType value = OFBsnHashPacketTypeSerializerVer14.readFrom(bb);
            OFBsnTlvHashPacketTypeVer14 bsnTlvHashPacketTypeVer14 = new OFBsnTlvHashPacketTypeVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvHashPacketTypeVer14);
            }
            return bsnTlvHashPacketTypeVer14;
        }
    }

    static class Builder
    implements OFBsnTlvHashPacketType.Builder {
        private boolean valueSet;
        private OFBsnHashPacketType value;

        Builder() {
        }

        @Override
        public int getType() {
            return 102;
        }

        @Override
        public OFBsnHashPacketType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashPacketType.Builder setValue(OFBsnHashPacketType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvHashPacketType build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashPacketTypeVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvHashPacketType.Builder {
        final OFBsnTlvHashPacketTypeVer14 parentMessage;
        private boolean valueSet;
        private OFBsnHashPacketType value;

        BuilderWithParent(OFBsnTlvHashPacketTypeVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 102;
        }

        @Override
        public OFBsnHashPacketType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvHashPacketType.Builder setValue(OFBsnHashPacketType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvHashPacketType build() {
            OFBsnHashPacketType value;
            OFBsnHashPacketType oFBsnHashPacketType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvHashPacketTypeVer14(value);
        }
    }
}

