/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvCrcEnabled;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvCrcEnabledVer14
implements OFBsnTlvCrcEnabled {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvCrcEnabledVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private static final short DEFAULT_VALUE = 0;
    private final short value;
    static final OFBsnTlvCrcEnabledVer14 DEFAULT = new OFBsnTlvCrcEnabledVer14(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvCrcEnabledVer14Funnel FUNNEL = new OFBsnTlvCrcEnabledVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvCrcEnabledVer14(short value) {
        this.value = U8.normalize(value);
    }

    @Override
    public int getType() {
        return 22;
    }

    @Override
    public short getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvCrcEnabled.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvCrcEnabledVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvCrcEnabledVer14 other = (OFBsnTlvCrcEnabledVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvCrcEnabledVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvCrcEnabledVer14 message) {
            bb.writeShort(22);
            bb.writeShort(5);
            bb.writeByte((int)U8.t(message.value));
        }
    }

    static class OFBsnTlvCrcEnabledVer14Funnel
    implements Funnel<OFBsnTlvCrcEnabledVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvCrcEnabledVer14Funnel() {
        }

        public void funnel(OFBsnTlvCrcEnabledVer14 message, PrimitiveSink sink) {
            sink.putShort((short)22);
            sink.putShort((short)5);
            sink.putShort(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvCrcEnabled> {
        Reader() {
        }

        @Override
        public OFBsnTlvCrcEnabled readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 22) {
                throw new OFParseError("Wrong type: Expected=0x16(0x16), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short value = U8.f(bb.readByte());
            OFBsnTlvCrcEnabledVer14 bsnTlvCrcEnabledVer14 = new OFBsnTlvCrcEnabledVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvCrcEnabledVer14);
            }
            return bsnTlvCrcEnabledVer14;
        }
    }

    static class Builder
    implements OFBsnTlvCrcEnabled.Builder {
        private boolean valueSet;
        private short value;

        Builder() {
        }

        @Override
        public int getType() {
            return 22;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvCrcEnabled.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvCrcEnabled build() {
            short value = this.valueSet ? this.value : (short)0;
            return new OFBsnTlvCrcEnabledVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvCrcEnabled.Builder {
        final OFBsnTlvCrcEnabledVer14 parentMessage;
        private boolean valueSet;
        private short value;

        BuilderWithParent(OFBsnTlvCrcEnabledVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 22;
        }

        @Override
        public short getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvCrcEnabled.Builder setValue(short value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvCrcEnabled build() {
            short value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvCrcEnabledVer14(value);
        }
    }
}

