/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnAutoNegotiationType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvAutoNegotiation;
import org.projectfloodlight.openflow.protocol.ver14.OFBsnAutoNegotiationTypeSerializerVer14;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvAutoNegotiationVer14
implements OFBsnTlvAutoNegotiation {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvAutoNegotiationVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 5;
    private final OFBsnAutoNegotiationType value;
    static final Reader READER = new Reader();
    static final OFBsnTlvAutoNegotiationVer14Funnel FUNNEL = new OFBsnTlvAutoNegotiationVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvAutoNegotiationVer14(OFBsnAutoNegotiationType value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvAutoNegotiationVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 144;
    }

    @Override
    public OFBsnAutoNegotiationType getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvAutoNegotiation.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvAutoNegotiationVer14(");
        b.append("value=").append((Object)this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvAutoNegotiationVer14 other = (OFBsnTlvAutoNegotiationVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals((Object)other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvAutoNegotiationVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTlvAutoNegotiationVer14 message) {
            bb.writeShort(144);
            bb.writeShort(5);
            OFBsnAutoNegotiationTypeSerializerVer14.writeTo(bb, message.value);
        }
    }

    static class OFBsnTlvAutoNegotiationVer14Funnel
    implements Funnel<OFBsnTlvAutoNegotiationVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvAutoNegotiationVer14Funnel() {
        }

        public void funnel(OFBsnTlvAutoNegotiationVer14 message, PrimitiveSink sink) {
            sink.putShort((short)144);
            sink.putShort((short)5);
            OFBsnAutoNegotiationTypeSerializerVer14.putTo(message.value, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvAutoNegotiation> {
        Reader() {
        }

        @Override
        public OFBsnTlvAutoNegotiation readFrom(ByteBuf bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 144) {
                throw new OFParseError("Wrong type: Expected=0x90(0x90), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 5) {
                throw new OFParseError("Wrong length: Expected=5(5), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFBsnAutoNegotiationType value = OFBsnAutoNegotiationTypeSerializerVer14.readFrom(bb);
            OFBsnTlvAutoNegotiationVer14 bsnTlvAutoNegotiationVer14 = new OFBsnTlvAutoNegotiationVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvAutoNegotiationVer14);
            }
            return bsnTlvAutoNegotiationVer14;
        }
    }

    static class Builder
    implements OFBsnTlvAutoNegotiation.Builder {
        private boolean valueSet;
        private OFBsnAutoNegotiationType value;

        Builder() {
        }

        @Override
        public int getType() {
            return 144;
        }

        @Override
        public OFBsnAutoNegotiationType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvAutoNegotiation.Builder setValue(OFBsnAutoNegotiationType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvAutoNegotiation build() {
            if (!this.valueSet) {
                throw new IllegalStateException("Property value doesn't have default value -- must be set");
            }
            if (this.value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvAutoNegotiationVer14(this.value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvAutoNegotiation.Builder {
        final OFBsnTlvAutoNegotiationVer14 parentMessage;
        private boolean valueSet;
        private OFBsnAutoNegotiationType value;

        BuilderWithParent(OFBsnTlvAutoNegotiationVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 144;
        }

        @Override
        public OFBsnAutoNegotiationType getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvAutoNegotiation.Builder setValue(OFBsnAutoNegotiationType value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvAutoNegotiation build() {
            OFBsnAutoNegotiationType value;
            OFBsnAutoNegotiationType oFBsnAutoNegotiationType = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvAutoNegotiationVer14(value);
        }
    }
}

