/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnTableChecksumStatsEntry;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTableChecksumStatsEntryVer14
implements OFBsnTableChecksumStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTableChecksumStatsEntryVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 9;
    private static final TableId DEFAULT_TABLE_ID = TableId.ALL;
    private static final U64 DEFAULT_CHECKSUM = U64.ZERO;
    private final TableId tableId;
    private final U64 checksum;
    static final OFBsnTableChecksumStatsEntryVer14 DEFAULT = new OFBsnTableChecksumStatsEntryVer14(DEFAULT_TABLE_ID, DEFAULT_CHECKSUM);
    static final Reader READER = new Reader();
    static final OFBsnTableChecksumStatsEntryVer14Funnel FUNNEL = new OFBsnTableChecksumStatsEntryVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTableChecksumStatsEntryVer14(TableId tableId, U64 checksum) {
        if (tableId == null) {
            throw new NullPointerException("OFBsnTableChecksumStatsEntryVer14: property tableId cannot be null");
        }
        if (checksum == null) {
            throw new NullPointerException("OFBsnTableChecksumStatsEntryVer14: property checksum cannot be null");
        }
        this.tableId = tableId;
        this.checksum = checksum;
    }

    @Override
    public TableId getTableId() {
        return this.tableId;
    }

    @Override
    public U64 getChecksum() {
        return this.checksum;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTableChecksumStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTableChecksumStatsEntryVer14(");
        b.append("tableId=").append(this.tableId);
        b.append(", ");
        b.append("checksum=").append(this.checksum);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTableChecksumStatsEntryVer14 other = (OFBsnTableChecksumStatsEntryVer14)obj;
        if (this.tableId == null ? other.tableId != null : !this.tableId.equals(other.tableId)) {
            return false;
        }
        return !(this.checksum == null ? other.checksum != null : !this.checksum.equals(other.checksum));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tableId == null ? 0 : this.tableId.hashCode());
        result = 31 * result + (this.checksum == null ? 0 : this.checksum.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTableChecksumStatsEntryVer14> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFBsnTableChecksumStatsEntryVer14 message) {
            message.tableId.writeByte(bb);
            bb.writeLong(message.checksum.getValue());
        }
    }

    static class OFBsnTableChecksumStatsEntryVer14Funnel
    implements Funnel<OFBsnTableChecksumStatsEntryVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTableChecksumStatsEntryVer14Funnel() {
        }

        public void funnel(OFBsnTableChecksumStatsEntryVer14 message, PrimitiveSink sink) {
            message.tableId.putTo(sink);
            message.checksum.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTableChecksumStatsEntry> {
        Reader() {
        }

        @Override
        public OFBsnTableChecksumStatsEntry readFrom(ByteBuf bb) throws OFParseError {
            TableId tableId = TableId.readByte(bb);
            U64 checksum = U64.ofRaw(bb.readLong());
            OFBsnTableChecksumStatsEntryVer14 bsnTableChecksumStatsEntryVer14 = new OFBsnTableChecksumStatsEntryVer14(tableId, checksum);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTableChecksumStatsEntryVer14);
            }
            return bsnTableChecksumStatsEntryVer14;
        }
    }

    static class Builder
    implements OFBsnTableChecksumStatsEntry.Builder {
        private boolean tableIdSet;
        private TableId tableId;
        private boolean checksumSet;
        private U64 checksum;

        Builder() {
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnTableChecksumStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public U64 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnTableChecksumStatsEntry.Builder setChecksum(U64 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTableChecksumStatsEntry build() {
            U64 checksum;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : DEFAULT_TABLE_ID;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            U64 u64 = checksum = this.checksumSet ? this.checksum : DEFAULT_CHECKSUM;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnTableChecksumStatsEntryVer14(tableId, checksum);
        }
    }

    static class BuilderWithParent
    implements OFBsnTableChecksumStatsEntry.Builder {
        final OFBsnTableChecksumStatsEntryVer14 parentMessage;
        private boolean tableIdSet;
        private TableId tableId;
        private boolean checksumSet;
        private U64 checksum;

        BuilderWithParent(OFBsnTableChecksumStatsEntryVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public TableId getTableId() {
            return this.tableId;
        }

        @Override
        public OFBsnTableChecksumStatsEntry.Builder setTableId(TableId tableId) {
            this.tableId = tableId;
            this.tableIdSet = true;
            return this;
        }

        @Override
        public U64 getChecksum() {
            return this.checksum;
        }

        @Override
        public OFBsnTableChecksumStatsEntry.Builder setChecksum(U64 checksum) {
            this.checksum = checksum;
            this.checksumSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTableChecksumStatsEntry build() {
            U64 checksum;
            TableId tableId;
            TableId tableId2 = tableId = this.tableIdSet ? this.tableId : this.parentMessage.tableId;
            if (tableId == null) {
                throw new NullPointerException("Property tableId must not be null");
            }
            U64 u64 = checksum = this.checksumSet ? this.checksum : this.parentMessage.checksum;
            if (checksum == null) {
                throw new NullPointerException("Property checksum must not be null");
            }
            return new OFBsnTableChecksumStatsEntryVer14(tableId, checksum);
        }
    }
}

