/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import io.netty.buffer.ByteBuf;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFUint64;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFUint64Ver13
implements OFUint64 {
    private static final Logger logger = LoggerFactory.getLogger(OFUint64Ver13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final U64 DEFAULT_VALUE = U64.ZERO;
    private final U64 value;
    static final OFUint64Ver13 DEFAULT = new OFUint64Ver13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFUint64Ver13Funnel FUNNEL = new OFUint64Ver13Funnel();
    static final Writer WRITER = new Writer();

    OFUint64Ver13(U64 value) {
        if (value == null) {
            throw new NullPointerException("OFUint64Ver13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public U64 getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFUint64.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ByteBuf bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFUint64Ver13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFUint64Ver13 other = (OFUint64Ver13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFUint64Ver13> {
        Writer() {
        }

        @Override
        public void write(ByteBuf bb, OFUint64Ver13 message) {
            bb.writeLong(message.value.getValue());
        }
    }

    static class OFUint64Ver13Funnel
    implements Funnel<OFUint64Ver13> {
        private static final long serialVersionUID = 1L;

        OFUint64Ver13Funnel() {
        }

        public void funnel(OFUint64Ver13 message, PrimitiveSink sink) {
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFUint64> {
        Reader() {
        }

        @Override
        public OFUint64 readFrom(ByteBuf bb) throws OFParseError {
            U64 value = U64.ofRaw(bb.readLong());
            OFUint64Ver13 uint64Ver13 = new OFUint64Ver13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)uint64Ver13);
            }
            return uint64Ver13;
        }
    }

    static class Builder
    implements OFUint64.Builder {
        private boolean valueSet;
        private U64 value;

        Builder() {
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFUint64.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFUint64 build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFUint64Ver13(value);
        }
    }

    static class BuilderWithParent
    implements OFUint64.Builder {
        final OFUint64Ver13 parentMessage;
        private boolean valueSet;
        private U64 value;

        BuilderWithParent(OFUint64Ver13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public U64 getValue() {
            return this.value;
        }

        @Override
        public OFUint64.Builder setValue(U64 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFUint64 build() {
            U64 value;
            U64 u64 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFUint64Ver13(value);
        }
    }
}

